package com.yeejoin.amos.boot.module.common.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.LinkageUnitDto;
import com.yeejoin.amos.boot.module.common.api.dto.LinkageUnitZhDto;
import com.yeejoin.amos.boot.module.common.api.dto.RequestData;
import com.yeejoin.amos.boot.module.common.api.entity.LinkageUnit;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 联动单位 Mapper 接口
 *
 * @author system_generator
 * @date 2021-07-16
 */
public interface LinkageUnitMapper extends BaseMapper<LinkageUnit> {
    /**
     * 列转行查询单个
     *
     * @param fieldCodes  列
     * @param groupCode   分组code
     * @param sequenceNbr 主键
     * @return List<Map>
     */
    LinkageUnitDto selectOne(
            @Param("isDelete") Boolean isDelete,
            @Param("fieldCodes") Map<String, Object> fieldCodes,
            @Param("groupCode") String groupCode,
            @Param("sequenceNbr") Long sequenceNbr
    );
    /**
     * * @param null
     * @return
     * <PRE>
     * author tw
     * date 2021/7/20
     * </PRE>
     */
    List<LinkageUnitZhDto> listLinkageUnitZhDto(@Param("pageNum")int pageNum, @Param("pageSize")int pageSize, @Param("par") RequestData par);

    Integer listLinkageUnitZhDtoCount(@Param("par")RequestData par);
    
    /**
     * 查询当前存在的联动单位及统计
     * @param isDelete
     * @param emergencyLinkageUnitCode
     * @return
     */
    List<Map<String, Object>> getEmergencyLinkageUnitCodeGroupByAndCount(@Param("bizOrgCode") String bizOrgCode);
    
    /**
     * 查询包含特岗人数及的具体信息
     * @return
     */
    Page<List<LinkageUnitDto>> getEmergencyLinkageUnitList(IPage<LinkageUnitDto> page,String unitName,
			 String linkageUnitType, String linkageUnitTypeCode, String emergencyLinkageUnitCode,String inAgreement, String bizOrgCode);

    List<LinkageUnitDto> exportToExcel(String unitName,String linkageUnitTypeCode,String emergencyLinkageUnitCode, String bizOrgCode);
    
}
