package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 * 生成厂商（供应商）
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_manufacturer_info")
@ApiModel(value="ManufacturerInfo对象")
public class ManufacturerInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "地址")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String address;

    @ApiModelProperty(value = "备注")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String remark;

    @ApiModelProperty(value = "联系电话")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String contactNumber;

    @ApiModelProperty(value = "维保")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String maintenanceservices;

    @ApiModelProperty(value = "曾用名")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String oldName;

    @ApiModelProperty(value = "法人代表")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String legalRep;

    @ApiModelProperty(value = "销售电话")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String salesTel;

    @ApiModelProperty(value = "服务电话")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String serviceTel;

    @ApiModelProperty(value = "拟定技术标准")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String technicalStandard;

    @ApiModelProperty(value = "人数")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer number;

    @ApiModelProperty(value = "技术人员数")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer technicianNumber;

    @ApiModelProperty(value = "固定资产")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private BigDecimal fixedAssets;

    @ApiModelProperty(value = "检测设备")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String testingEquipment;

    @ApiModelProperty(value = "资质")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String qualifications;

    @ApiModelProperty(value = "历史沿革")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String historicalEvolution;

    @ApiModelProperty(value = "研制记录")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String researchRecord;

    @ApiModelProperty(value = "生产企业类型")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String productType;

    @ApiModelProperty(value = "图片")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String img;

    @ApiModelProperty(value = "注册资本")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private BigDecimal registeredCapital;

    @ApiModelProperty(value = "企业性质ID")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Long natureId;

    @ApiModelProperty(value = "类型id")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Long typeId;

    @ApiModelProperty(value = "国家id")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Long countryId;

    @ApiModelProperty(value = "省份id")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Long provinceId;

    @ApiModelProperty(value = "国家")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String country;

    @ApiModelProperty(value = "企业性质")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String nature;

    @ApiModelProperty(value = "省份")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String province;

    @ApiModelProperty(value = "类型")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String type;


}
