package com.yeejoin.equipmanage.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Getter
@AllArgsConstructor
public enum WaterResourceTypeEnum {
    消火栓("hydrant", "消火栓"),
    消防水鹤("crane", "消防水鹤"),
    消防水池("pool", "消防水池"),
    天然水源("natural", "天然水源"),
    消防水箱("waterTank", "消防水箱"),
    工业水池("industryPool", "工业水池");

    private String code;
    private String name;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static List<Map<String, String>> getEnumList() {
        return Arrays.stream(WaterResourceTypeEnum.values()).map(e -> {
            Map<String, String> map = new HashMap<>();
            map.put("code", e.getCode());
            map.put("name", e.getName());
            return map;
        }).collect(Collectors.toList());
    }
}
