package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireEquipmentSignalLogDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireEquipmentSignalLog;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireEquipmentSignalLogMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IFireEquipmentSignalLogService;
import com.yeejoin.amos.boot.module.ccs.biz.util.RequestUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 设备报警信息日志表服务实现类
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Service
public class FireEquipmentSignalLogServiceImpl extends BaseService<FireEquipmentSignalLogDto, FireEquipmentSignalLog, FireEquipmentSignalLogMapper> implements IFireEquipmentSignalLogService {

    @Autowired
    HttpServletRequest request;

    /**
     * 告警列表查询-最新告警及跑马灯使用
     */
    public List<FireEquipmentSignalLogDto> fireEquipmentAlarmLogList() {
        Map<String, Object> params = RequestUtil.getRequestParamMap(request);
        return this.getBaseMapper().queryAlarmLogList(params);
    }


    public List<FireEquipmentSignalLogDto> todayAlarmLogList(String stationCode) throws ParseException {
        Map<String, Object> params = new HashMap<>();
        //未确认
        params.put("confirmState","0");
        params.put("beginDate", DateUtils.dateFormat(new Date(),DateUtils.DATE_PATTERN));
        params.put("endDate", DateUtils.dateFormat(new Date(),DateUtils.DATE_PATTERN));
        params.put("stationCode",stationCode);
        return this.getBaseMapper().queryAlarmLogList(params);
    }

    public void saveBatchLog(List<FireEquipmentSignalLog> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            this.saveBatch(list);
        }
    }

    //TODO 修改待补充
    public void updateBatchLog(List<FireEquipmentSignalLog> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.stream().forEach(item -> {
                UpdateWrapper<FireEquipmentSignalLog> wrapper = new UpdateWrapper<>();
                wrapper.lambda().eq(FireEquipmentSignalLog::getFireEquipmentMrid, item.getFireEquipmentMrid())
                        .eq(FireEquipmentSignalLog::getFireEquipmentIndexKey, item.getFireEquipmentIndexKey());
            });

        }
    }
}