package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireSignalDayStatisticsDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireSignalDayStatistics;
import com.yeejoin.amos.boot.module.ccs.api.enums.SignalTypeOfAlarm;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireSignalDayStatisticsMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IFireSignalDayStatisticsService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.text.ParseException;
import java.util.*;

/**
 * 换流站告警日统计服务实现类
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Service
public class FireSignalDayStatisticsServiceImpl extends BaseService<FireSignalDayStatisticsDto, FireSignalDayStatistics, FireSignalDayStatisticsMapper> implements IFireSignalDayStatisticsService {


    public int alarmTimesCount(String stationCode, String beginDate, String endDate) {
        LambdaQueryWrapper<FireSignalDayStatistics> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(StringUtils.isNotBlank(stationCode), FireSignalDayStatistics::getStationCode, stationCode);
        wrapper.ge(FireSignalDayStatistics::getCollectDate, beginDate);
        wrapper.le(FireSignalDayStatistics::getCollectDate, endDate);
        wrapper.eq(FireSignalDayStatistics::getIsAlarm, true);
        List<FireSignalDayStatistics> list = this.list(wrapper);
        return list.stream().mapToInt(FireSignalDayStatistics::getReportTimes).sum();
    }

    public List<String> alarmTimesTrend(String stationCode, String beginDate, String endDate) {
        return this.baseMapper.queryAlarmTimesTrend(stationCode, beginDate, endDate, null);
    }

    @Override
    public Map<String, Object> selectForAlarmCount() throws ParseException {
        //TODO 统计告警类型的指标信息
        //今天
        String today = DateUtils.dateFormat(new Date(), DateUtils.DATE_PATTERN);
        //昨天
        Date yesterday = DateUtils.dateAdd(new Date(), 1, false);
        String yesterdayStr = DateUtils.dateFormat(yesterday, DateUtils.DATE_PATTERN);
        //本周开始日期
        Date weekBegin = DateUtils.beginDateOfWeek(new Date());
        //本月开始日期
        Date monthBegin = DateUtils.getBeginDateOfMonth(new Date());
        //今日告警数量
        int todayAlarmTimes = this.alarmTimesCount(null, today, today);
        //昨日警情数量
        int yesterdayAlarmTimes = this.alarmTimesCount(null, yesterdayStr, yesterdayStr);
        //本周警情数目
        int weekAlarmTimes = this.alarmTimesCount(null, DateUtils.dateFormat(weekBegin, DateUtils.DATE_PATTERN), today);
        //本月警情数目
        int monthAlarmTimes = this.alarmTimesCount(null, DateUtils.dateFormat(monthBegin, DateUtils.DATE_PATTERN), today);
        Map<String, Object> result = new HashMap<>(8);
        result.put("todayAlarmTimes", todayAlarmTimes);
        result.put("yesterdayAlarmTimes", yesterdayAlarmTimes);
        result.put("weekAlarmTimes", weekAlarmTimes);
        result.put("monthAlarmTimes", monthAlarmTimes);
        return result;
    }

    @Override
    public Map<String, Object> selectForAlarmTrend(String beginData, String endData) {
        //故障告警
        List<String> faultAlarm = this.baseMapper.queryAlarmTimesTrend(null, beginData, endData, SignalTypeOfAlarm.FAULT_ALARM.getCode());
        //火灾告警
        List<String> fireAlarm = this.baseMapper.queryAlarmTimesTrend(null, beginData, endData, SignalTypeOfAlarm.FIRE_ALARM.getCode());
        //屏蔽
        List<String> shieldAlarm = this.baseMapper.queryAlarmTimesTrend(null, beginData, endData, SignalTypeOfAlarm.SHIELD_ALARM.getCode());
        //漏油
        List<String> oilAlarm = this.baseMapper.queryAlarmTimesTrend(null, beginData, endData, SignalTypeOfAlarm.OIL_LEAK_ALARM.getCode());
        //告警
        List<String> alarm = this.baseMapper.queryAlarmTimesTrend(null, beginData, endData, SignalTypeOfAlarm.ALARM.getCode());
        Map<String, Object> result = new LinkedHashMap<>(8);
        result.put("faultAlarm", faultAlarm);
        result.put("fireAlarm", fireAlarm);
        result.put("shieldAlarm", shieldAlarm);
        result.put("oilLeakAlarm", oilAlarm);
        result.put("alarm", alarm);
        return result;
    }

    @Override
    public Map<String, Object> todayAlarmPercent(String beginData, String endData) {
        Map<String, Object> re = new LinkedHashMap<>(8);
        //故障告警
        re.put("faultAlarm", this.signalReportTimesCount(beginData, endData, SignalTypeOfAlarm.FAULT_ALARM.getCode()));
        //火灾告警
        re.put("fireAlarm", this.signalReportTimesCount(beginData, endData, SignalTypeOfAlarm.FIRE_ALARM.getCode()));
        //屏蔽
        re.put("shieldAlarm", this.signalReportTimesCount(beginData, endData, SignalTypeOfAlarm.SHIELD_ALARM.getCode()));
        //漏油
        re.put("oilLeakAlarm", this.signalReportTimesCount(beginData, endData, SignalTypeOfAlarm.OIL_LEAK_ALARM.getCode()));
        //告警
        re.put("alarm", this.signalReportTimesCount(beginData, endData, SignalTypeOfAlarm.ALARM.getCode()));
        return re;
    }

    private int signalReportTimesCount(String beginDate, String endDate, String signalType) {
        LambdaQueryWrapper<FireSignalDayStatistics> wrapper = new LambdaQueryWrapper<>();
        wrapper.ge(FireSignalDayStatistics::getCollectDate, beginDate);
        wrapper.le(FireSignalDayStatistics::getCollectDate, endDate);
        wrapper.eq(FireSignalDayStatistics::getSignalType, signalType);
        List<FireSignalDayStatistics> list = this.list(wrapper);
        return list.stream().mapToInt(FireSignalDayStatistics::getReportTimes).sum();
    }
}