package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.entity.DynamicFormGroup;
import com.yeejoin.equipmanage.service.IEqDynamicFormInstanceService;
import com.yeejoin.equipmanage.service.IEqDynamicFormService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;


/**
 * 动态表单控制器
 *
 * @author duanwei
 * @date 2021-03-08
 */
@RestController
@Api(tags = "动态表单Api")
@RequestMapping(value = "/dynamic-form", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class DynamicFormController extends AbstractBaseController {

    @Autowired
    IEqDynamicFormInstanceService iEqDynamicFormInstanceService;

    @Autowired
    IEqDynamicFormService iEqDynamicFormService;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "生成id及编号", notes = "创建分组及字段使用")
    @PutMapping("/nextIdCode")
    public Object generateSeqAndCode() {
        return iEqDynamicFormService.nextIdCode();
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "分组及字段查询", notes = "分组及字段查询")
    @RequestMapping(value = "/groups", method = RequestMethod.GET)
    public DynamicFormGroup queryGroupsAndOptions(@RequestParam Long groupId) {
        return iEqDynamicFormService.getGroupsAndColumns(groupId);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "动态表单配置保存", notes = "动态表单配置保存")
    @PostMapping("/save")
    public DynamicFormGroup saveGroupAndColumn(@RequestBody DynamicFormGroup dynamicFormGroup) {
        String orgCode = getOrgCode();
        return iEqDynamicFormService.saveGroupAndColumn(dynamicFormGroup,orgCode);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "指定分组的分组的字段及值")
    @GetMapping("/instance-detail")
    public Object getInstanceDetail(@RequestParam(required = false) String instanceId,
                                    @RequestParam Long groupId) {
        return iEqDynamicFormService.getInstanceDetail(instanceId, groupId);
    }


}


