package com.yeejoin.equipmanage.service.impl;

import com.yeejoin.equipmanage.common.utils.XmlBuilder;
import com.yeejoin.equipmanage.common.vo.LonAndLatEntityVo;
import com.yeejoin.equipmanage.common.vo.LonAndLatList;
import com.yeejoin.equipmanage.common.vo.SpeedAndTimeEntityVo;
import com.yeejoin.equipmanage.common.vo.SpeedAndTimeList;
import com.yeejoin.equipmanage.service.ICarLonAndLatDataService;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;


/**
 * @author keyong
 * @title: CarLonAndLatDataServiceImpl
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2020/11/27 10:19
 */
@Service
public class CarLonAndLatDataServiceImpl implements ICarLonAndLatDataService {

    @Override
    public List<LonAndLatEntityVo> listCarLonAndLat() throws Exception {
        Resource resource = new ClassPathResource("car-history-track-data.xml");
        try (InputStreamReader inputStreamReader = new InputStreamReader(resource.getInputStream());
             BufferedReader br = new BufferedReader(inputStreamReader);) {
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while((line = br.readLine())!=null)
            {
                buffer.append(line);
            }
            LonAndLatList list = (LonAndLatList) XmlBuilder.xmlStrToObject(LonAndLatList.class, buffer.toString());
            return list.getDataList();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList<>();
    }

    @Override
    public List<SpeedAndTimeEntityVo> listCarSpeedAndGround() throws Exception {
        Resource resource = new ClassPathResource("car-history-trend-data.xml");
        try (InputStreamReader inputStreamReader = new InputStreamReader(resource.getInputStream());
             BufferedReader br = new BufferedReader(inputStreamReader);) {
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = br.readLine()) != null) {
                buffer.append(line);
            }
            SpeedAndTimeList list = (SpeedAndTimeList) XmlBuilder.xmlStrToObject(SpeedAndTimeList.class, buffer.toString());
            return list.getDataList();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList<>();
    }
}
