package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jcs.api.dto.OrgUsrSafeReportDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrgUsrSafeReport;
import com.yeejoin.amos.boot.module.jcs.api.mapper.OrgUsrSafeReportMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IOrgUsrSafeReportService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Date;
import java.util.List;

/**
 * 机场单位消防安全报告服务实现类
 *
 * @author litw
 * @date 2021-10-09
 */
@Service
public class OrgUsrSafeReportServiceImpl extends BaseService<OrgUsrSafeReportDto,OrgUsrSafeReport,OrgUsrSafeReportMapper> implements IOrgUsrSafeReportService {
    /**
     * 分页查询
     */
    public Page<OrgUsrSafeReportDto> queryForOrgUsrSafeReportPage(Page<OrgUsrSafeReportDto> page,
                                                                  @Condition(Operator.like) String name,
                                                                  String typeCode,
                                                                  Date  takeEffectYear,
                                                                  Long companyId)   {
        return this.queryForPage(page, "rec_date", false, name,typeCode,takeEffectYear,companyId);
    }

    /**
     * 列表查询 示例
     */
    public List<OrgUsrSafeReportDto> queryForOrgUsrSafeReportList()   {
        return this.queryForList("" , false);
    }
}