package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description:
 * @author: keyong
 * @createDate: 2024/01/16
 */
@Getter
@AllArgsConstructor
public enum GridStatusEnum {


    DDJ("待登记", "1"),
    JXSGLYDSH("经销商管理员待审核", "2"),
    YWC("已完成", "3"),
    WTG("未通过", "4"),
    SJDSH("设计待审核", "5"),
    ROLESDSH("设计待审核/工程待审核", "6"),
    PQYYDSH("片区运营待审核", "7"),
    GCDSH("工程待审核", "8"),
    ZGDSH("整改待审核", "9"),
    DZG("待整改", "10"),
    YSROLESDSH("投融待审核/法务待审核", "11"),
    TRDSH("投融待审核", "12"),
    ZCDSH("资产待审核", "13"),
    FWDSH("法务待审核", "14"),
    DTJYS("待提交验收", "15");


    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    public static GridStatusEnum getNodeByCode(String code) {
        GridStatusEnum gridStatusEnum = null;
        for(GridStatusEnum type: GridStatusEnum.values()) {
            if (type.getCode().equals(code)) {
                gridStatusEnum = type;
                break;
            }
        }
        return gridStatusEnum;
    }

}
