package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

/**
 * 聚富通枚举
 *
 * <p>
 * ProjectName: amos-boot-zx-biz
 * PackageName: com.yeejoin.amos.boot.module.hygf.api.Enum
 *
 * @author yangyang
 * @version v1.0
 * @date 2024/7/18 11:51
 */
@Data
public class IcbcEnum {

    /**
     * 开户状态
     */
    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    public static enum OpenAccountState {

        INITIAL("未开户", "00"),

        OPENING("开户中", "01"),

        SUCCESSFULLY("开户成功", "02"),

        FAIL("开户失败", "03");

        /**
         * 名称，描述
         */
        private String name;
        /**
         * 编码
         */
        private String code;

        public static String getNameByCode(String code, String defaultName) {
            for (OpenAccountState state : OpenAccountState.values()) {
                if (state.getCode().equals(code)) {
                    return state.getName();
                }
            }
            if (StringUtils.isNotEmpty(defaultName)) {
                return defaultName;
            }
            return null;
        }

    }

    /**
     * 协议状态, 0-未生效，1-已生效，2-过期，3-作废，4-待短信确认
     */
    @Getter
    @NoArgsConstructor
    @AllArgsConstructor
    public static enum ProtocolStatus {

        NOT_EFFECTIVE("未生效", "0"),

        EFFECTIVE("已生效", "1"),

        OVERDUE("过期", "2"),

        DISCARD("作废", "3"),

        WAITTING_SMS("待短信确认", "4");

        /**
         * 名称，描述
         */
        private String name;
        /**
         * 编码
         */
        private String code;

        public static String getNameByCode(String code, String defaultName) {
            for (ProtocolStatus state : ProtocolStatus.values()) {
                if (state.getCode().equals(code)) {
                    return state.getName();
                }
            }
            if (StringUtils.isNotEmpty(defaultName)) {
                return defaultName;
            }
            return null;
        }

    }
}
