package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.util.StringUtils;

import java.util.List;

@Getter
@AllArgsConstructor
public enum StatisicsHomePageEnum {
    序号("xh",0),
    省份("sf",1),
    项目公司("regionalCompaniesName",2),
    代理商("developerName",3),
    实际建设容量("realScale",4),
    未勘察("wkc",5),
    勘察未通过("kcwtg",6),
    勘察未通过容量("kcwtgrl",7),
    勘察进行中("kcjxz",8),
    勘察进行中容量("kcjxzrl",9),
    勘察已完成("kcywc",10),
    勘察已完成容量("kcywcrl",11),
    备货未通过("bhwtg",12),
    备货未通过容量("bhwtgrl",13),
    备货进行中("bhjxz",14),
    备货进行中容量("bhjxzrl",15),
    备货已完成("bhywc",16),
    备货已完成容量("bhywcrl",17),
    施工未通过("sgwtg",18),
    施工未通过容量("sgwtgrl",19),
    施工进行中("sgjxz",20),
    施工进行中容量("sgjxzrl",21),
    施工已完成("sgywc",22),
    施工已完成容量("sgywcrl",23),
    并网未通过("bwwtg",24),
    并网未通过容量("bwwtgrl",25),
    并网进行中("bwjxz",26),
    并网进行中容量("bwjxzrl",27),
    并网已完成("bwywc",28),
    并网已完成容量("bwywcrl",29),
    验收未通过("yswtg",30),
    验收未通过容量("yswtgrl",31),
    验收进行中("ysjxz",32),
    验收进行中容量("ysjxzrl",33),
    验收已完成("ysywc",34),
    验收已完成容量("ysywcrl",35),
    融资公司("rzgs",36),
    融资户数("rzhs",37),
    融资容量("rzrl",38),
    融资单价("rzdj",39),
    放款金额("fkje",40);
    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private int code;




    public static Integer getCodeByName(String name) {

        for(StatisicsHomePageEnum obj: StatisicsHomePageEnum.values()) {
            if (obj.getName().equals(name)) {
              return obj.getCode();
            }
        }
        return null;
    }


}
