package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 并网验收节点
 *
 * @author system_generator
 * @date 2024-08-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AcceptanceCheckDto", description = "并网验收节点")
public class AcceptanceCheckDto extends BaseDto {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "施工单id")
	private Long workOrderId;

	@ApiModelProperty(value = "施工电站id")
	private Long workOrderPowerStationId;

	@ApiModelProperty(value = "农户id")
	private Long peasantHouseholdId;

	@ApiModelProperty(value = "验收状态")
	private String acceptanceCheckStatus;

	@ApiModelProperty(value = "节点标识")
	private String basicGridNode;

	@ApiModelProperty(value = "片区审核")
	private String powerStationAreaStatus;

	@ApiModelProperty(value = "法务审核")
	private String powerStationLegalStatus;

	@ApiModelProperty(value = "投融审核")
	private String powerStationFinancingStatus;

	@ApiModelProperty(value = "资产审核")
	private String powerStationAssetsStatus;

	@ApiModelProperty(value = "实例id")
	private String instanceId;

	private String acceptanceTime;

	// 电站编号
	private String peasantHouseholdNo;
	// 户主姓名
	private String ownersName;
	/// 项目地址
	private String projectAddressName;
	// 并网日期
	private Date gridConnectionTime;

	private String regionalCompaniesName;

	private String serviceAgent;

	// 并网登记id

	private Long fonGridId;

	private String isAudit;

	private String rectificationStatus;

// 电站安装规模
	private String scale;
	private String realScale;

	private String province;
}
