package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.RegionalCompanies;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 经销商人员信息
 *
 * @author system_generator
 * @date 2023-07-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="UnitInfoDto", description="经销商人员信息")
public class UnitInfoDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "企业名称")
    private String name;

    @ApiModelProperty(value = "注册地址")
    private String registerAddress;

    @ApiModelProperty(value = "工作地址")
    private String workAddress;

    @ApiModelProperty(value = "负责人名称")
    private String headName;

    @ApiModelProperty(value = "负责人电话")
    private String headPhone;

    @ApiModelProperty(value = "负责人身份证号码")
    private String headIdNumber;

    @ApiModelProperty(value = "负责人身份证照片正面")
    private String headCardPhotoFront;

    @ApiModelProperty(value = "负责人身份证照片反面")
    private String headCardPhotoBack;

    @ApiModelProperty(value = "管理员账户名")
    private String adminLoginName;

    @ApiModelProperty(value = "管理员账户名")
    private String adminUserName;

    @ApiModelProperty(value = "管理员电话")
    private String adminPhone;

    @ApiModelProperty(value = "管理员密码")
    private String adminLoginPwd;

    @ApiModelProperty(value = "管理员平台用户id")
    private String adminUserId;

    @ApiModelProperty(value = "平台公司id")
    private Long amosCompanySeq;

    @ApiModelProperty(value = "上级单位id")
    private Long parentUnitId;

    @ApiModelProperty(value = "角色id")
    private String roleId;

    @ApiModelProperty(value = "注册地址省-市-区")
    private String registerPcd;

    @ApiModelProperty(value = "工作地址省-市-区")
    private String workPcd;

    @ApiModelProperty(value = "注册地址省-市-区code")
    private String registerPcdCode;

    @ApiModelProperty(value = "工作地址省-市-区code")
    private String workPcdCode;

    @ApiModelProperty(value = "单位类型")
    private String unitType;

    @ApiModelProperty(value = "单位类型code")
    private String unitTypeCode;

    @ApiModelProperty(value = "管辖机构")
    private String managementUnit;

    @ApiModelProperty(value = "管辖单位id")
    private String managementUnitId;


    @ApiModelProperty(value = "单位code")
    private String amosCompanyCode;

    //所属区域公司id

    private List<String> regionalCompaniesSeq;
    //所属区域公司名称
    private String regionalCompaniesName;
    //所属区域公司code
    private String regionalCompaniesCode;


    List<RegionalCompanies> regionalCompanies;

    /**
     *是否加入黑名单
     * */
    private int blacklist;
    /**
     *审核状态
     * */
    private int auditStatus;
}
