package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2024/1/4
 */

@Data
public class WorkOrderPage {


    @ApiModelProperty(value = "农户id")
    protected Long sequenceNbr;

    @ApiModelProperty(value = "农户信息编号")
    private String peasantHouseholdNo;

    @ApiModelProperty(value = "开发商")
    private String developerName;

    @ApiModelProperty(value = "区域公司")
    private String regionalCompaniesName;

    @ApiModelProperty(value = "派工单编号")
    private String workOrderNum;

    @ApiModelProperty(value = "业主姓名")
    private String ownersName;

    @ApiModelProperty(value = "工程负责人")
    private String projectRegionManager;


    @ApiModelProperty(value = "施工负责人")
    private String constructionRegionManager;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "完工时间")
    private Date completionDate;

    @ApiModelProperty(value = "项目地址")
    private String projectAddressName;

    @ApiModelProperty(value = "电站施工状态")
    private String powerStationConstructionStatus;

    @ApiModelProperty(value = "派工电站id")
    protected Long workOrderPowerStationId;
    @ApiModelProperty(value = "派工电站节点标识")
    protected String workOrderPowerStationNode;

    @ApiModelProperty(value = "派工单id")
    protected String workOrderId;
    /**
     * 区域公司id
     */
    private Long regionCompanyId;

    @ApiModelProperty(value = "平台经销商单位id")
    private Long amosDealerId;

    private String  type;
    @ApiModelProperty(value = "片区审核")
    private String  powerStationAreaStatus ;
    @ApiModelProperty(value = "设计审核")
    private String  powerStationDesignStatus ;
    @ApiModelProperty(value = "工程审核")
    private String  powerStationEngineeringStatus ;
    @ApiModelProperty(value = "判断是否有进行中的整改单数量")
    private Long  rectificationNum ;
    @ApiModelProperty(value = "最后一条作废整改单id")
    private Long  rollbackOrderId ;
    int current;
    int size;
    @ApiModelProperty(value = "数据过滤标识")
    private List<String> workOrderPowerStationNodes ;
    @ApiModelProperty(value = "判断是否可以审核,默认不可以")
    private String  isAudit ;

    @ApiModelProperty(value = "历史审核意见")
    private String  auditIdea ;
    @ApiModelProperty(value = "实例id")
    private String  instanceId ;

    @ApiModelProperty(value = "电站安装规模")
    private String  scale ;
    @ApiModelProperty(value = "电站实际规模")
    private String  realScale ;
    
    private String province;

    @ApiModelProperty(value = "首次编辑施工资料日期")
    private String firstConstructionDate;

    private String startTime;
    private String endTime;
}
