package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/11/20
 */
@Data
public class YearGenerateEX {
    @ExcelProperty(value = "电站编号", index = 0)
    @ApiModelProperty(value = "电站编码")
    private String code;
    @ExcelProperty(value = "电站名称", index = 1)
    @ApiModelProperty(value = "电站名称")
    private String name;
    @ExcelProperty(value = "时间", index = 2)
    String timeDate;
    @ExcelProperty(value = "业主姓名", index = 3)
    @ApiModelProperty(value = "业主姓名")
    private String userName;
    @ExcelProperty(value = "电站联系人", index = 4)
    @ApiModelProperty(value = "电站联系人")
    private String stationContact;

    /**
     * 满发小时数
     *
     * */
    @ExcelProperty(value = "满发小时数(h)", index = 5)
    private Double fullhour;



    // 年发电量
    @ExcelProperty(value = "年发电量(kWh)", index = 6)
    private Double yearGenerate;

    // 年收益
    @ExcelProperty(value = "年收益（元）", index = 7)
    private Double yearIncome;

    /**
     * 累计发电量
     */
    @ExcelProperty(value = "累计发电量（MWh）", index = 8)
    private Double accumulatedPower;
}
