package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 审核单
 *
 * @author system_generator
 * @date 2024-08-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value="hygf_rectification_order",autoResultMap = true)
public class HygfRectificationOrder extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 农户姓名
     */
	@TableField("peasant_househole_name")
    private String peasantHouseholeName;

    /**
     * 农户编号
     */
	@TableField("peasant_househole_code")
    private String peasantHouseholeCode;

    /**
     * 农户编号
     */
    @TableField("project_address_name")
    private String projectAddressName;
    /**
     * 农户场站id
     */
	@TableField("peasant_househole_id")
    private Long peasantHouseholeId;

    /**
     * 整改项
     */
	@TableField(value = "rectification_idea", typeHandler = FastjsonTypeHandler.class)
    private List<Object>  rectificationIdea;

    /**
     * 整改附件
     */
	@TableField(value = "rectification_file", typeHandler = FastjsonTypeHandler.class)
    private List<Object> rectificationFile;

    /**
     * 整改结果附件
     */
	@TableField(value = "result_file", typeHandler = FastjsonTypeHandler.class)
    private List<Object> resultFile;

    /**
     * 整改结果
     */
	@TableField(value ="rectification_result", typeHandler = FastjsonTypeHandler.class)
    private List<Object> rectificationResult;

    /**
     * 审核意见
     */
	@TableField("audit_idea")
    private String auditIdea;

    /**
     * 审核结果
     */
	@TableField("audit_result")
    private String auditResult;


    /**
     * 整改类型
     */
    @TableField("rectification_type")
    private String rectificationType;


    /**
     * 整改来源
     */
    @TableField("rectification_source")
    private String rectificationSource;
    
    /**
     * 整改来源
     */
    @TableField(exist = false)
    private String rectificationSourceName;

    /**
     * 整改历史意见
     */
    @TableField(value = "rectification_history", typeHandler = FastjsonTypeHandler.class)
    private List<Object> rectificationHistory;

    /**
     * 整改单状态
     */
    @TableField("rectification_status")
    private String rectificationStatus;


    /**
     * 是否提交 0 提交 1 暂存
     */
    @TableField(exist = false)
    private String addorSubmit;


    /**
     * 工程负责人
     */
    @TableField("project_region_manger")
    private String projectRegionManager;


    /**
     * 是否提交 0 提交 1 暂存
     */
    @TableField(exist = false)
    private String isAudit;

    @TableField(exist = false)
    private String rectificationResultWeb;
    @TableField(exist = false)
    private String rectificationHistoryWeb;
    @TableField(exist = false)
    private String rectificationIdeaWeb;


}
