package com.yeejoin.amos.boot.module.hygf.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.hygf.api.config.UserEmpower;
import com.yeejoin.amos.boot.module.hygf.api.dto.PowerStationTimeStatisticsDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.PeasantHousehold;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 农户信息 Mapper 接口
 *
 * @author system_generator
 * @date 2023-07-07
 */
public interface PeasantHouseholdMapper extends BaseMapper<PeasantHousehold> {
    List<PeasantHousehold> selectPeasantHouseholdList(@Param("developerId") Long developerId,
                                                      @Param("regionalCompaniesSeq")Long regionalCompaniesSeq,
                                                      @Param("peasantHouseholdNo")String peasantHouseholdNo,
                                                      @Param("ownersName")String ownersName,
                                                      @Param("ids")String ids,
                                                      @Param("orderBy") String orderBy
    );
    List<PeasantHousehold> selectPeasantHouseholdListsg(@Param("unitInfoCode") String unitInfoCode,
                                                      @Param("regionalCompaniesSeq")Long regionalCompaniesSeq,
                                                      @Param("peasantHouseholdNo")String peasantHouseholdNo,
                                                      @Param("ownersName")String ownersName,
                                                        @Param("ids")String ids

    );
    @UserEmpower(field={"regional_companies_code"},dealerField={"developer_code","regional_companies_code","developer_user_id"} ,fieldConditions ={"eq","in","eq"} ,relationship="and")
    List<PeasantHousehold> queryForPage( String developerCode,String ownersName,Long developerId,Integer isCertified,String preparationMoneyState, String peasantHouseholdNo,String province,String isHistory,String regionalCompaniesSeq);


    List<Map<String,Object>> selectUserIsHouse(String telephone);

    Integer selectIsAllRevoke(String peasantHouseholdNo);
    Integer selectIsAllRevokePassCount(String peasantHouseholdNo);

    void deleteHphByUserId(String userId);
    void deletePauByUserId(String userId);
    void deleteAliByUserId(String userId);
    void deleteHhcByUserId(String userId);

    PeasantHousehold selectReview(String sequenceNbr);

     Integer selectPowerStationNumber(String amosUserId);

    void deleteHphByNo(String peasantHouseholdNo);

    void deleteHhcByNo(String peasantHouseholdNo);

    List<PeasantHousehold> getInfoByIds(@Param(value = "ids") List<String> ids);
    List<PeasantHousehold> getInfoByIdsHistory(@Param(value = "ids") List<String> ids);

    /**
     * 分页查询电站统计
     * @param statisticsDto
     * @return
     */
    @UserEmpower(field = {"hph.regional_companies_code"}, dealerField = {"hph.regional_companies_code"}, fieldConditions = {"in"}, relationship = "and")
    List<PowerStationTimeStatisticsDto> queryForPageByPowerStationStatistics(@Param("statisticsDto") PowerStationTimeStatisticsDto statisticsDto);

    /**
     * 获取电站时间详情
     * @param sequenceNbrList
     * @return
     */
    @UserEmpower(field = {"hph.regional_companies_code"}, dealerField = {"hph.regional_companies_code"}, fieldConditions = {"in"}, relationship = "and")
    List<PowerStationTimeStatisticsDto> getPowerStationTimeDetail(@Param("list") List<String> sequenceNbrList);

    /**
     * 获取所有电站详情
     * @param map
     * @return
     */
    @UserEmpower(field = {"hph.regional_companies_code"}, dealerField = {"hph.regional_companies_code"}, fieldConditions = {"in"}, relationship = "and")
    List<PowerStationTimeStatisticsDto> getAllPowerStationTimeDetail(@Param("map")Map<String, Object> map);

    List<PowerStationTimeStatisticsDto> getKcTime(@Param("list") List<Long> peasantHouseholdIdList);

    List<PowerStationTimeStatisticsDto> getDzhtqyTime(@Param("list") List<Long> peasantHouseholdIdList);

    List<PowerStationTimeStatisticsDto> getSjTime(@Param("list") List<Long> peasantHouseholdIdList);

    List<PowerStationTimeStatisticsDto> getFhbhTime(@Param("list") List<Long> peasantHouseholdIdList);

    List<PowerStationTimeStatisticsDto> getSgTime(@Param("list") List<Long> peasantHouseholdIdList);

    List<PowerStationTimeStatisticsDto> getBwTime(@Param("list") List<Long> peasantHouseholdIdList);

    List<PowerStationTimeStatisticsDto> getYsTime(@Param("list") List<Long> peasantHouseholdIdList);

    List<PowerStationTimeStatisticsDto> getTrTime(@Param("list") List<Long> peasantHouseholdIdList);

//    String getHygfCommercialScale(Long surveyInformationId);
}
