package com.yeejoin.amos.boot.module.hygf.api.mapper;


import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.yeejoin.amos.boot.module.hygf.api.config.UserEmpower;
import com.yeejoin.amos.boot.module.hygf.api.dto.PreparationDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.PreparationMoneyDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.PreparationPageDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.PeasantHousehold;
import com.yeejoin.amos.boot.module.hygf.api.entity.PreparationMoney;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 发货单 Mapper 接口
 *
 * @author system_generator
 * @date 2023-08-17
 */
public interface PreparationMoneyMapper extends BaseMapper<PreparationMoney> {


    List<PeasantHousehold> getPeasantHouseholdData(@Param("sequenceNbr") Long sequenceNbr, @Param("ownersName") String ownersName, @Param("projectAddress") String projectAddress);

    @UserEmpower(field = {"regional_companies_code"}, dealerField = {"amos_unit_org_code", "regional_companies_code"}, fieldConditions = {"eq", "in"}, relationship = "and")
    List<PreparationMoney> selectPageList(@Param(value = "dto") PreparationDto preparationDto);

    @UserEmpower(field = {"regional_companies_code"}, dealerField = {"developer_code", "regional_companies_code"}, fieldConditions = {"eq", "in"}, relationship = "and")
    List<Map<String, Object>> preparationStation(@Param(value = "preparationMoneyState") String preparationMoneyState,
                                                 @Param(value = "ownersName") String ownersName,
                                                 @Param(value = "regionalCompaniesSeq") String regionalCompaniesSeq,
                                                 @Param(value = "developerId") String developerId,
                                                 @Param(value = "state") String state,
                                                 @Param(value = "province") String province,
                                                 @Param(value = "projectAddress") String projectAddress,
                                                 @Param(value = "startTime") String startTime,
                                                 @Param(value = "endTime") String endTime);
    PreparationMoney selectPreparationMoneyInfo(@Param(value = "peasantHouseholdId") String peasantHouseholdId);
}
