package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.google.common.net.HttpHeaders;
import com.yeejoin.amos.boot.module.hygf.api.config.UserLimits;
import com.yeejoin.amos.boot.module.hygf.api.dto.CommerceInfoDto;
import com.yeejoin.amos.boot.module.hygf.api.util.CommonResponseNewUtil;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.FinancingInfoServiceImpl;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.StatisticsHomepageServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@RestController
@Api(tags = "公共接口")
@RequestMapping(value = "/common")
public class CommonController {

    @Autowired
    FinancingInfoServiceImpl financingInfoService;
    @Autowired
    CommonServiceImpl commonService;
    @Autowired
    StatisticsHomepageServiceImpl statisticsHomepageService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/selectRegion")
    @ApiOperation(httpMethod = "GET", value = "查询全国省份", notes = "查询全国省份")
    public ResponseModel<List<Map<String,Object>>> selectRegion() {
        return ResponseHelper.buildResponse(financingInfoService.selectRegion());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/selectRegionByParentCode")
    @ApiOperation(httpMethod = "GET", value = "查询省市区", notes = "查询省市区")
    public ResponseModel<List<Map<String,Object>>> selectRegionByParentCode(@RequestParam(value = "parentCode", defaultValue = "0") String parentCode,
                                                                            @RequestParam(value = "level", defaultValue = "1") String level) {
        return ResponseHelper.buildResponse(financingInfoService.selectRegionByParentCode(parentCode, level));
    }

    /**
     * 设备信息下载
     *
     * @return
     */
    @GetMapping(value = "/downInformation")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "资料下载", notes = "资料下载")
    public void downList(HttpServletResponse response, @RequestParam(required = false) String surveyInformationId,
                         @RequestParam(required = false)List<String> peasantHouseholdIds,
                         @RequestParam(required = false)String processInstanceId) throws IOException {

// 设置响应头
        response.setContentType("application/zip");


        commonService.downZiliao(surveyInformationId,peasantHouseholdIds,processInstanceId,response);
        System.out.println("zip下载成功");
    }


    /**
     * 设备信息下载
     *
     * @return
     */
    @GetMapping(value = "/test")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "资料下载", notes = "资料下载")
    public void test(HttpServletResponse response) throws IOException {

// 设置响应头
        response.setContentType("application/zip");
        commonService.test(response);
        System.out.println("zip下载成功");
    }

    /**
     * 设备信息下载
     *
     * @return
     */
    @GetMapping(value = "/getSchedule")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "资料下载进度获取", notes = "资料下载进度获取")
    public ResponseModel<Object> getSchedule(String peasantHouseholdId) {

      return ResponseHelper.buildResponse(commonService.getSchedule(peasantHouseholdId));


    }


    /**
     * 统计首页环形图
     *
     * @return
     */
    @GetMapping(value = "/statisticsHomepage")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "首页统计环形图及统计表", notes = "首页统计环形图及统计表")
    @UserLimits
    public ResponseModel<Map<String, Object>> statisticsHomepage(@RequestParam(required = false) String developerCode,
                                             @RequestParam(required = false) String regionalCompaniesCode,
                                             @RequestParam(required = false) String province,
                                             @RequestParam(required = false) String city,
                                             @RequestParam(required = false) String district) {

        return ResponseHelper.buildResponse(statisticsHomepageService.statisticsHomepage(developerCode,regionalCompaniesCode,province,city,district));

    }

    /**
     * 统计首页环形图
     *
     * @return
     */
    @GetMapping(value = "/statisticsTop")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表上方统计表", notes = "列表上方统计表")
    @UserLimits
    public ResponseModel<Map<String, Object>> statisticsTop(@RequestParam(required = false) String developerCode,
                                             @RequestParam(required = false) String regionalCompaniesCode,
                                             @RequestParam(required = false) String province,
                                             @RequestParam(required = false) String city,
                                             @RequestParam(required = true) String type,
                                             @RequestParam(required = false) String district) {

        return ResponseHelper.buildResponse(statisticsHomepageService.statisticsTop(type,developerCode,regionalCompaniesCode,province,city,district));

    }

    /**
     * 统计首页环形图
     *
     * @return
     */
    @GetMapping(value = "/homePageExport")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "资料下载进度获取", notes = "资料下载进度获取")
    @UserLimits
    public  void homePageExport(@RequestParam(required = false) String developerCode,
                                                          @RequestParam(required = false) String regionalCompaniesCode,
                                                          @RequestParam(required = false) String province,
                                                          @RequestParam(required = false) String city,
                                                          @RequestParam(required = false) String district,
                                                            HttpServletResponse response) throws IOException {
        statisticsHomepageService.homePageExport(developerCode,regionalCompaniesCode,province,city,district,response);

    }


}
