package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.WorkOrderPowerStationDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.WorkOrderPowerStationServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 施工派工单电站
 *
 * @author system_generator
 * @date 2024-01-02
 */
@RestController
@Api(tags = "施工派工单电站Api")
@RequestMapping(value = "/work-order-power-station")
public class WorkOrderPowerStationController extends BaseController {

    @Autowired
    WorkOrderPowerStationServiceImpl workOrderPowerStationServiceImpl;

    /**
     * 新增施工派工单电站
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增施工派工单电站", notes = "新增施工派工单电站")
	public ResponseModel<WorkOrderPowerStationDto> save(@RequestBody WorkOrderPowerStationDto model) {
	    model = workOrderPowerStationServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新施工派工单电站", notes = "根据sequenceNbr更新施工派工单电站")
	public ResponseModel<WorkOrderPowerStationDto> updateBySequenceNbrWorkOrderPowerStation(@RequestBody WorkOrderPowerStationDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(workOrderPowerStationServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除施工派工单电站", notes = "根据sequenceNbr删除施工派工单电站")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(workOrderPowerStationServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个施工派工单电站",  notes = "根据sequenceNbr查询单个施工派工单电站")
	public ResponseModel<WorkOrderPowerStationDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(workOrderPowerStationServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "施工派工单电站分页查询",  notes = "施工派工单电站分页查询")
	public ResponseModel<Page<WorkOrderPowerStationDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<WorkOrderPowerStationDto> page = new Page<WorkOrderPowerStationDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(workOrderPowerStationServiceImpl.queryForWorkOrderPowerStationPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "施工派工单电站列表全部数据查询",   notes = "施工派工单电站列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<WorkOrderPowerStationDto>> selectForList() {
	    return ResponseHelper.buildResponse(workOrderPowerStationServiceImpl.queryForWorkOrderPowerStationList());
	}
}
