package com.yeejoin.amos.boot.module.hygf.biz.vo;


import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

/**
 *
 *
 * @author hzz
 * @date 2024-09-29
 */
@Data
@ApiModel(value = "RepaymentExcelVO", description = "还款excel实体类")
public class RepaymentExcelVO implements Serializable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "区域公司")
    @Excel(name = "区域公司", width = 50, orderNum = "1")
    private String companyName;

    @ApiModelProperty(value = "期次")
    @Excel(name = "期次", width = 30, orderNum = "2")
    private String period;

    @ApiModelProperty(value = "还款日期")
    @Excel(name = "还款日期", width = 30, orderNum = "3")
    private LocalDate repayDate;

    @ApiModelProperty(value = "租金(元)")
    @Excel(name = "租金(元)", width = 30, orderNum = "4")
    private String rent;

    @ApiModelProperty(value = "利息(元)")
    @Excel(name = "利息(元)", width = 30, orderNum = "5")
    private String interest;

    @ApiModelProperty(value = "本金(元)")
    @Excel(name = "本金(元)", width = 30, orderNum = "6")
    private String principal;

    @ApiModelProperty(value = "放款批次")
    @Excel(name = "放款批次", width = 30, orderNum = "7")
    private String loanPeriod;
}
