package com.yeejoin.amos.boot.module.jxiop.biz.service;


import com.yeejoin.amos.boot.module.jxiop.biz.dto.CoreValuesDto;

import java.util.List;
import java.util.Map;

public interface CoreCommonService {
    /**
     * @param stationNames 要查的场站名称需要使用逗号分隔 eg：夏造风机,石灰山风机
     * @param pointsNames  要查的测点名称需要使用逗号分隔开 eg:日发电量,月发电量，年发电
     * @return CoreValuesDto
     * @deprecated 远程调用core服务根据厂长名称
     */
    List<CoreValuesDto> getValuesByStationNamesAndPointsNames(String stationNames, String pointsNames);

    /**
     * @param pointName
     * @return
     */
    Map<String, Object> getPointValuesByParams(String stationName, String filterNames, String pointName);

    /**
     * @param coreValuesDtoList
     * @return
     * @deprecated 获取测点数据总和
     */
    Double getSumOfByPointName(List<CoreValuesDto> coreValuesDtoList, String pointName);

    /**
     * @param coreValuesDtoList
     * @return
     * @deprecated 获取测点数据平均值
     */
    Double getAverageOfByPointName(List<CoreValuesDto> coreValuesDtoList, String pointName);

}
