package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.dto.RegionDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.Region;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.RegionMapper;
import com.yeejoin.amos.boot.module.jxiop.api.service.IRegionService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-06-08
 */
@Service
public class RegionServiceImpl extends BaseService<RegionDto,Region,RegionMapper> implements IRegionService {
    /**
     * 分页查询
     */
    public Page<RegionDto> queryForRegionPage(Page<RegionDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<RegionDto> queryForRegionList()   {
        return this.queryForList("" , false);
    }

    public Region getRegionByRegionCode ( String regionCode){
        return  this.getOne(new LambdaQueryWrapper<Region>().eq(Region::getRegionCode,regionCode));
    }
    //根据regionName获取regionCode
    public Region getRegionCodeByRegionName(String regionName) {
        return this.getOne(new LambdaQueryWrapper<Region>().like(Region::getRegionName,regionName).eq(Region::getLevel,1));
    }
}