package com.yeejoin.amos.boot.module.jxiop.biz.jxdz.factory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.Enum.JXDZAccessTypeEnum;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.Enum.JXDZCodeEnum;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.entity.WindDeviceDataEntity;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.impl.WindDeviceDataServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.utils.JXDZUtils;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.vo.NeedDataVO;
import com.yeejoin.amos.boot.module.jxiop.biz.jxdz.vo.WindDeviceDataVO;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.JXDZMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class FDZSBJCServiceImpl implements IJXDZService {
    @Autowired
    JXDZUtils jxdzUtils;
    @Autowired
    WindDeviceDataServiceImpl windDeviceDataService;
    @Autowired
    JXDZMapper jxdzMapper;

    @Override
    public void backupData(List list, Long dateTime) {
        Date date = new Date();
        if (CollectionUtil.isNotEmpty(list)) {
            List<WindDeviceDataEntity> windDeviceDataEntityList = new ArrayList<>();
            list.forEach(item -> {
                WindDeviceDataEntity windDeviceDataEntity = BeanUtil.copyProperties(item, WindDeviceDataEntity.class);
                windDeviceDataEntity.setDateTime(dateTime);
                windDeviceDataEntity.setRecDate(date);
                windDeviceDataEntityList.add(windDeviceDataEntity);
            });
            windDeviceDataService.saveBatch(windDeviceDataEntityList);
        }
    }

    @Override
    public List buildData(Integer accessType, Long dateTime) {
        List<WindDeviceDataVO> list = new ArrayList<>();
        if (JXDZAccessTypeEnum.BULU.getCode().equals(accessType)) {
            List<WindDeviceDataEntity> windDeviceDataEntityList = windDeviceDataService.list(new LambdaQueryWrapper<WindDeviceDataEntity>().eq(WindDeviceDataEntity::getDateTime, dateTime));
            list = BeanUtil.copyToList(windDeviceDataEntityList, WindDeviceDataVO.class);
        } else {
            JSONArray zzBusinessData = getZZBusinessData();
            if (CollectionUtil.isNotEmpty(zzBusinessData)) {
                for (Object o : zzBusinessData) {
                    if (o instanceof Map) {
                        Map map = (Map) o;
                        JSONObject jsonObject = new JSONObject(map);
                        if (jsonObject.getString("name").contains("风机")) {
                            list.add(getWindDeviceDataVO(jsonObject));
                        }
                    }

                }
            }
        }
        return list;
    }

    /**
     * 获取风电设备数据
     * @param jsonObject
     * @return
     */
    private WindDeviceDataVO getWindDeviceDataVO(JSONObject jsonObject) {
        WindDeviceDataVO windDeviceDataVO = new WindDeviceDataVO();
        String sequenceNbr = jsonObject.getString("sequenceNbr");
        windDeviceDataVO.setName(jsonObject.getString("name"));
        windDeviceDataVO.setCode(getWindDeviceCode(jsonObject.getString("name")));
        //开始调用具体列表接口
        JSONArray windDeviceJSONArray = getWindDeviceDataBySequenceNbr(sequenceNbr);
        if (CollectionUtil.isNotEmpty(windDeviceJSONArray)) {
            for (Object o : windDeviceJSONArray) {
                if (o instanceof Map) {
                    Map map = (Map) o;
                    JSONObject result = new JSONObject(map);
                    String pointName = (String) map.get("pointName");
                    if ("日发电量".equals(pointName)) {
                        windDeviceDataVO.setGenerationDaily(result.getDouble("value"));
                    }
                    if ("月发电量".equals(pointName)) {
                        windDeviceDataVO.setGenerationMonth(result.getDouble("value"));
                    }
                    if ("年发电量".equals(pointName)) {
                        windDeviceDataVO.setGenerationYear(result.getDouble("value")/10000);
                        windDeviceDataVO.setGenerationGross(result.getDouble("value")/10000);
                    }
                }
            }
        }
        return windDeviceDataVO;
    }

    /**
     * 获取风电设备Code
     * @param name
     * @return
     */
    private String getWindDeviceCode(String name) {
        String replaceString = name.replace("风机", "");
        Integer value = Integer.valueOf(replaceString);
        String field = "%#" + value + "风机系统%";
        String replaceField = "%#" + replaceString + "风机系统%";
        return jxdzMapper.getDeviceCode(JXDZCodeEnum.XZ.getCode(), field, replaceField);
    }

    /**
     * 根据主键获取具体的风电测点数据
     * @param sequenceNbr
     * @return
     */
    private JSONArray getWindDeviceDataBySequenceNbr(String sequenceNbr) {
        JSONObject jsonObject = jxdzUtils.sendCoreGetRequest("/core/datastorage/gateway/point/list?groupId=" + sequenceNbr + "&dataType=analog");
        if (!Objects.isNull(jsonObject)) {
            if (jsonObject.getInteger("status") == HttpStatus.OK.value()) {
                return jsonObject.getJSONArray("result");
            }
        }
        return new JSONArray();
    }

    /**
     * 获取装置测点数据
     * @return
     */
    private JSONArray getZZBusinessData() {
        JSONObject jsonObject = jxdzUtils.sendCoreGetRequest("/core/front-gateway-device/tree?gatewayId=1762633242759958530");
        if (!Objects.isNull(jsonObject)) {
            if (jsonObject.getInteger("status") == HttpStatus.OK.value()) {
                JSONArray result = jsonObject.getJSONArray("result");
                if (CollectionUtil.isNotEmpty(result)) {
                    JSONObject firstObject = result.getJSONObject(0).getJSONArray("children").getJSONObject(0);
                    if (!Objects.isNull(firstObject)) {
                        JSONArray children = firstObject.getJSONArray("children");
                        if (CollectionUtil.isNotEmpty(children)) {
                            for (Object child : children) {
                                if (child instanceof Map) {
                                    Map map = (Map) child;
                                    JSONObject childJSON = new JSONObject(map);
                                    if ("装置测点".equals(childJSON.getString("name"))) {
                                        return childJSON.getJSONArray("children");
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return new JSONArray();
    }

    @Override
    public void sendData(Integer accessType, NeedDataVO needDataVO, List list) {
        if(CollectionUtil.isNotEmpty(list)){
            jxdzUtils.sendJXDZPostRequest("/ngnsyncjiangxiyw/accesshourdata/windDeviceData", accessType, needDataVO, list);
        }
    }
}
