package com.yeejoin.equipmanage.common.entity;

import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 货架结构
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_warehouse_structure")
@ApiModel(value = "WarehouseStructure对象", description = "货架结构")
public class WarehouseStructure extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "位置编码")
	private String code;

	@ApiModelProperty(value = "名称")
	private String name;

	@ApiModelProperty(value = "全称")
	private String fullName;
	
	@ApiModelProperty(value = "父ID")
	private Long parentId;

	@ApiModelProperty(value = "位置类型")
	private Long cellType;

	@ApiModelProperty(value = "货位code")
	private String cellCode;

	@ApiModelProperty(value = "仓库ID")
	private Long warehouseId;


	//新加

	@ApiModelProperty(value = "机构/部门名称")
	@TableField("biz_org_name")
	private String bizOrgName;

	@ApiModelProperty(value = "机构编码")
	@TableField("biz_org_code")
	private String bizOrgCode;



	private String remark;
	
	@ApiModelProperty(value = "预控系统中的ID字段")
    private Long sourceId;
	
	@ApiModelProperty(value = "预控系统中的code字段")
    private String sourceCode;

	@TableField(exist = false)
	private List<WarehouseStructure> children;

}
