package com.yeejoin.amos.knowledgebase.face.enumeration;

import java.util.Comparator;
import java.util.List;

/**
 * @author 杨博超
 * @ClassName RoleName
 * @Deacription
 **/
public enum KnowledgeRoleName {

    VIEWER("浏览者", 0, 0, 1, 1),
    INPUTER("录入者", 0, 1, 1, 1),
    AUDITOR("审核者", 0, 2, 1, 1),
    TAG_MANAGER("标签管理员", 1, 0, 0, 0);


    private String roleName;

    private int tagManagerScore;
    private int docManagerScore;
    private int docGroupManagerScore;
    private int searchScore;

    KnowledgeRoleName(String roleName, int tagManagerScore, int docManagerScore, int docGroupManagerScore, int searchScore) {
        this.roleName = roleName;
        this.tagManagerScore = tagManagerScore;
        this.docManagerScore = docManagerScore;
        this.docGroupManagerScore = docGroupManagerScore;
        this.searchScore = searchScore;
    }


    public String getRoleName() {
        return roleName;
    }


    public int getTagManagerScore() {
        return tagManagerScore;
    }

    public int getDocManagerScore() {
        return docManagerScore;
    }

    public int getDocGroupManagerScore() {
        return docGroupManagerScore;
    }

    public int getSearchScore() {
        return searchScore;
    }

    public static KnowledgeRoleName getInstance(String roleName) {
        KnowledgeRoleName knowledgeRoleName = null;

        for (KnowledgeRoleName roleNameIns : KnowledgeRoleName.values()) {
            if (roleNameIns.getRoleName().equals(roleName))
                knowledgeRoleName = roleNameIns;
        }
        return knowledgeRoleName;
    }


    public static KnowledgeRoleName getMaxScore(List<String> roleNames, Comparator<KnowledgeRoleName> comparator) {
        KnowledgeRoleName maxScore = null;
        for (String roleName : roleNames) {
            if (maxScore == null) {
                maxScore = getInstance(roleName);
                continue;
            }

            KnowledgeRoleName current =  getInstance(roleName);
            if(comparator.compare(current,maxScore) > 0)
                maxScore = current;
        }
        return maxScore;
    }

}
