package com.yeejoin.amos.latentdanger.common.enums;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
public enum MsgSubscribeEnum {

    /**
     * 风险评价提醒推送
     */
    风险评价提醒推送("riskFatorApp", "风险评价提醒", "风险评价提醒", false, "default"),
    /**
     * 隐患治理推送
     */
    隐患治理推送("latentDangerApp", "隐患治理", "隐患治理移动端推送", false, "default");

    private String msgType;
    private String title;
    private String desc;
    private Boolean canConfig;
    private String type;

    MsgSubscribeEnum(String msgType, String title, String desc, Boolean canConfig, String type) {
        this.msgType = msgType;
        this.title = title;
        this.desc = desc;
        this.canConfig = canConfig;
        this.type = type;
    }

    public static List<Map<String, String>> getEnumList() {
        List<Map<String, String>> list = Lists.newArrayList();
        for (MsgSubscribeEnum e : MsgSubscribeEnum.values()) {
            if (e.canConfig && !e.getMsgType().equals("checkRecordNoPushApp") && !e.getType().equals("email")) {
                Map<String, String> msgType = Maps.newHashMap();
                msgType.put(e.getMsgType(), e.getTitle());
                list.add(msgType);
            }
        }
        return list;
    }

    public static MsgSubscribeEnum getByMsgType(String msgType) {
        for (MsgSubscribeEnum typeEnum : MsgSubscribeEnum.values()) {
            if (msgType.equals(typeEnum.msgType)) {
                return typeEnum;
            }
        }
        return null;
    }

    public String getMsgType() {
        return msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Boolean getCanConfig() {
        return canConfig;
    }

    public void setCanConfig(Boolean canConfig) {
        this.canConfig = canConfig;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
