package com.yeejoin.equipmanage.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.BaseBill;
import com.yeejoin.equipmanage.common.entity.Maintain;
import com.yeejoin.equipmanage.common.entity.MaintainDetail;
import com.yeejoin.equipmanage.common.utils.DateUtils;
import com.yeejoin.equipmanage.common.utils.NameUtils;
import com.yeejoin.equipmanage.common.vo.StockDataVO;
import com.yeejoin.equipmanage.service.IMaintainService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 *
 *
 * @author wujiang
 * @date 2020-07-14
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/maintain", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class MaintainController extends AbstractBaseController {

	@Autowired
	@Lazy
	IMaintainService iMaintainService;

	/**
	 * 新增
	 *
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public boolean saveMaintain(HttpServletRequest request, @RequestBody Maintain maintain) {
		return iMaintainService.save(maintain);
	}

	/**
	 * 根据id删除
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iMaintainService.removeById(id);
	}

	/**
	 * 修改
	 *
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
	public boolean updateByIdMaintain(HttpServletRequest request, @RequestBody Maintain maintain) {
		return iMaintainService.updateById(maintain);
	}

	/**
	 * 根据id查询
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public Maintain selectById(HttpServletRequest request, @PathVariable Long id) {
		return iMaintainService.getById(id);
	}

	/**
	 * 列表分页查询
	 *
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<Maintain> listPage(String pageNum, String pageSize, Maintain maintain) {

		Page<Maintain> pageBean;
		QueryWrapper<Maintain> maintainQueryWrapper = new QueryWrapper<>();
		Class<? extends Maintain> aClass = maintain.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(maintain);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(maintain);
						maintainQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(maintain);
						maintainQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(maintain);
						maintainQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(maintain);
						maintainQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		IPage<Maintain> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iMaintainService.page(pageBean, maintainQueryWrapper);
		return page;
	}

	/**
	 * 保养
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/exec/{type}", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "保养", notes = "根据id查询")
	public BaseBill maintain(@RequestBody List<MaintainDetail> list, @PathVariable String type) throws Exception {
		Maintain maintain = iMaintainService.exec(list, type, getUserInfo());
		BaseBill baseBill = new BaseBill(maintain.getBillCode(), getUserInfo().getRealName(), DateUtils.getNowStrLong(),
				maintain.getId(), new ArrayList<StockDataVO>());
		return baseBill;
	}
}
