package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.EquipmentDetail;
import com.yeejoin.equipmanage.common.entity.EquipmentOnCar;
import com.yeejoin.equipmanage.common.entity.StockDetail;

import java.util.List;
import java.util.Map;

/**
 * 库存明细 服务类
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface IStockDetailService extends IService<StockDetail> {

	Page<StockDetail> pageCategoryStock(Page<EquipmentDetail> pageBean, String category, Long warehouseStructureId);

	IPage<StockDetail> pageStockCategory(Page<StockDetail> pageBean, String category, Long warehouseStructureId);

	IPage<StockDetail> pagePlaceEquip(Page<StockDetail> pageBean, Long equipmentDetailId, Long warehouseStructureId);

	List<StockDetail> loadOnPerson(List<String> ids);

	StockDetail unloadPerson(Map<String, Object> map);

	StockDetail unloadOnCar(Map<String, Object> id);

	boolean updateBatch(List<EquipmentOnCar> list, Long status);
}
