package com.yeejoin.amos.knowledgebase.face.service;


import com.yeejoin.amos.knowledgebase.face.model.KnowledgeDocAnnotateModel;
import com.yeejoin.amos.knowledgebase.face.orm.dao.DocAnnotateMapper;
import com.yeejoin.amos.knowledgebase.face.orm.entity.KnowledgeDocAnnotate;
import com.yeejoin.amos.knowledgebase.face.util.RemoteData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.exception.BaseException;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;


/**
 * <p>
 * 知识库文档注释 服务类
 * </p>
 *
 * @author ningtianqing
 * @since 2020-09-16
 */
@Component
public class DocAnnotateService extends BaseService<KnowledgeDocAnnotateModel, KnowledgeDocAnnotate, DocAnnotateMapper> {


    @Autowired
    private DocContentService docContentService;
    /**
     * @author ningtianqing
     * @description 创建注释信息
     * @Param [commentsModel]
     * @return com.yeejoin.amos.knowledgebase.face.model.KnowledgeDocAnnotateModel
     **/
    @Transactional(rollbackFor = {Exception.class, BaseException.class})
    public KnowledgeDocAnnotateModel createAnnotate(KnowledgeDocAnnotateModel annotateModel) {
        annotateModel.setAgencyCode(RequestContext.getAgencyCode());
        annotateModel.setUserId(RequestContext.getExeUserId());
        annotateModel.setCreateTime(new Date());
        docContentService.updateHtmlContent(annotateModel.getDocSeq(), annotateModel.getHtmlContent());
        return this.createWithModel(annotateModel);
    }

    /**
     * @author ningtianqing
     * @description 更新注释信息ss
     * @Param [commentsModel]
     * @return com.yeejoin.amos.knowledgebase.face.model.KnowledgeDocAnnotateModel
     **/
    public KnowledgeDocAnnotateModel updateAnnotate(KnowledgeDocAnnotateModel annotateModel) {
        KnowledgeDocAnnotateModel oldModel = this.queryBySeq(annotateModel.getSequenceNbr());
        Bean.copyExistPropertis(annotateModel, oldModel);
        return this.updateWithModel(oldModel);
    }
    /**
     * @author ningtianqing
     * @description 删除注释
     * @Param [id]
     * @return String
     **/
    @Transactional(rollbackFor = {Exception.class, BaseException.class})
    public Long deleteAnnotate(KnowledgeDocAnnotateModel annotateModel)   {
        if (ValidationUtil.isEmpty(annotateModel.getDocSeq()) || ValidationUtil.isEmpty(annotateModel.getHtmlContent())) {
           this.deleteBySeq(annotateModel.getSequenceNbr());
           return annotateModel.getSequenceNbr();
        } else {
            docContentService.updateHtmlContent(annotateModel.getDocSeq(), annotateModel.getHtmlContent());
            this.deleteBySeq(annotateModel.getSequenceNbr());
            return annotateModel.getSequenceNbr();
        }

    }
    /**
     * @author ningtianqing
     * @description 根据文档id查询注释列表
     * @Param [docSeq]
     * @return List
     **/
    public List<KnowledgeDocAnnotateModel> queryForAnnotateList(String docSeq)   {
        List<KnowledgeDocAnnotateModel> list = this.queryForList("CREATE_TIME",true, docSeq);
        Set<String> userIds = list.stream().filter(item -> !ValidationUtil.isEmpty(item)).map(KnowledgeDocAnnotateModel::getUserId).collect(Collectors.toSet());
        Map<String, String> userMap =  RemoteData.getUserMap(userIds);
        list.forEach(item -> {
            item.setUsername(userMap.get(item.getUserId()));
            item.setIsCurrentUser(ValidationUtil.equals(item.getUserId(),RequestContext.getExeUserId()));
        });
        return list;
    }
}
