package com.yeejoin.amos.knowledgebase.face.util;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

@Component
public class PropertiesLoader {
    /**
     * 图片服务器地址
     */
    @Value("${pic-server.uri}")
    private String picUri;

    /**
     * 图片服务器路由标识
     */
    @Value("${pic-server.router}")
    private String picRouter;

    @PostConstruct
    public void savePropertiesData(){
        IOConfig.PIC_URI = picUri;
        IOConfig.PIC_ROUTER = picRouter;
    }
}
