package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 商务信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="CommercialDto", description="商务信息")
public class CommercialDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "商务类型")
    private String type;

    @ApiModelProperty(value = "申请人")
    private String applicant;

    @ApiModelProperty(value = "身份证号")
    private String idCard;

    @ApiModelProperty(value = "申请人联系电话")
    private String telephone;

    @ApiModelProperty(value = "省市区")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Integer> projectAddress;

    @ApiModelProperty(value = "省市区名称")
    private String projectAddressName;

   @ApiModelProperty(value = "省市区文字集合")
   private List<String> projectAddressText;

    @ApiModelProperty(value = "设备信息")
    private String device;

    @ApiModelProperty(value = "电子系统造价")
    private Float cost;

    @ApiModelProperty(value = "安装规模")
    private String scale;

    @ApiModelProperty(value = "法务类型")
    private String legalType;

    @ApiModelProperty(value = "有效联系电话")
    private String legalContactTelephone;

    @ApiModelProperty(value = "紧急联系人")
    private String legalEmergentTelephone;

    @ApiModelProperty(value = "结婚证文件标识")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> marriageCredit;

    @ApiModelProperty(value = "房产证文件标识")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> realEstateCredit;

    @ApiModelProperty(value = "身份证正反面文件标识")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> idCardCredit;

    @ApiModelProperty(value = "户口本文件标识")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> householdBookCredit;

    @ApiModelProperty(value = "手持身份证文件标识")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> handIdCardCredit;

    @ApiModelProperty(value = "踏勘照片文件标识")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> surveyPhotosWeb;

    @ApiModelProperty(value = "组件平面图与组串连线图文件标识")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> formationWeb;

    @ApiModelProperty(value = "房屋所有权继承说明文件标识")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> inheritWeb;

    @ApiModelProperty(value = "户用光伏电站项目合作协议文件标识")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> agreementWeb;

    @ApiModelProperty(value = "用户手持身份证照片文件标识")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> handIdCardLegal;

    @ApiModelProperty(value = "法人营业执照文件标识")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> licenseLegal;

    @ApiModelProperty(value = "法定代理人身份证文件标识")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> agentLegal;

    @ApiModelProperty(value = "房产证明文件或乡镇街道土管部门房屋产权证明文件文件标识")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> realEstateLegal;

    @ApiModelProperty(value = "房屋屋顶租赁协议/户用光伏共建开发协议文件标识")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> houseAgreementLegal;

    @ApiModelProperty(value = "法人的企业征信报告、工商内档文件标识")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> creditReportLegal;

    @ApiModelProperty(value = "项目备案证文件标识")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> filingsLegal;

    @ApiModelProperty(value = " 省市区详细地址")
    private String projectAddressDetail;

    @ApiModelProperty(value = "勘察表id")
    private Long surveyInformationId;
}
