package com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanHealthIndexDay;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.PvHealthIndexDay;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

public interface PvHealthIndexDayMapper extends BaseMapper<PvHealthIndexDay> {
    @Select("<script>"+
            "SELECT `health_index` AS healthIndex,`health_index` AS `value`, rec_date AS recDate, anomaly, substr(analysis_time,1,10) as analysisTime,station,equipment_name AS equipmentName, point_name as pointName, index_address as indexAddress, ( CASE HEALTH_LEVEL WHEN '危险' THEN 3 WHEN '警告' THEN 2 WHEN '注意' THEN 1 ELSE 0 END ) AS status" +
            " FROM analysis_data.pv_health_index_day WHERE  analysis_obj_type = #{analysisObjType}" +
            "<if test='endTimeTop!= null'>  and ts &lt;= #{endTimeTop} </if> " +
            "<if test='startTimeTop!= null'>  and  ts &gt;= #{startTimeTop} </if> " +
            "<if test='area!= null '> AND area = #{area} </if> " +
            "<if test='indexAddress!= null '> AND index_address = #{indexAddress} </if> " +
            "<if test='pointName!= null '>AND point_name = #{pointName} </if> " +
            "<if test='station!= null'>AND station = #{station} </if>" +
            "<if test='healthLevel!= null '>AND health_level = #{healthLevel} </if>" +
            "<if test='subarray!= null'>AND subarray = #{subarray} </if> " +
            "<if test='equipmentName!= null'>AND equipment_name = #{equipmentName} </if>" +
            "<if test='gatewayIds != null and gatewayIds.size() > 0'>AND GATEWAY_ID IN <foreach collection='gatewayIds' item='gatewayId' open='(' separator=',' close=')'>#{gatewayId}</foreach></if>" +
            "order by health_index "+
            "<if test='current != null and size != null'>limit ${current},${size} </if>" +
            "</script>")
    List<PvHealthIndexDay> selectData(@Param("station")String station,
                                      @Param("analysisType")String analysisType,
                                      @Param("indexAddress")String indexAddress,
                                      @Param("healthLevel")String healthLevel,
                                      @Param("area")String area,
                                      @Param("analysisObjType")String analysisObjType,
                                      @Param("subarray")String subarray,
                                      @Param("pointName")String pointName,
                                      @Param("startTimeTop") String startTimeTop,
                                      @Param("endTimeTop")String endTimeTop,
                                      @Param("equipmentName")String equipmentName
            , @Param("current")Integer current, @Param("size")Integer size,@Param("gatewayIds") List<String> gatewayIds);


    @Select("<script>"+
            "SELECT count(1)" +
            " FROM analysis_data.pv_health_index_day WHERE  analysis_obj_type = #{analysisObjType}" +
            "<if test='endTimeTop!= null'>  and ts &lt;= #{endTimeTop} </if> " +
            "<if test='startTimeTop!= null'>  and  ts &gt;= #{startTimeTop} </if> " +
            "<if test='area!= null '> AND area = #{area} </if> " +
            "<if test='indexAddress!= null '> AND index_address = #{indexAddress} </if> " +
            "<if test='pointName!= null '>AND point_name = #{pointName} </if> " +
            "<if test='station!= null'>AND station = #{station} </if>" +
            "<if test='healthLevel!= null '>AND health_level = #{healthLevel} </if>" +
            "<if test='subarray!= null'>AND subarray = #{subarray} </if> " +
            "<if test='equipmentName!= null'>AND equipment_name = #{equipmentName} </if>" +
            "<if test='gatewayIds != null and gatewayIds.size() > 0'>AND GATEWAY_ID IN <foreach collection='gatewayIds' item='gatewayId' open='(' separator=',' close=')'>#{gatewayId}</foreach></if>" +
            "</script>")
    int selectDataTotal(@Param("station")String station,@Param("analysisType")String analysisType,@Param("indexAddress")String indexAddress,@Param("healthLevel")String healthLevel,@Param("area")String area,@Param("analysisObjType")String analysisObjType, @Param("subarray")String subarray, @Param("pointName")String pointName,@Param("startTimeTop") String startTimeTop, @Param("endTimeTop")String endTimeTop, @Param("equipmentName")String equipmentName, @Param("gatewayIds") List<String> gatewayIds);

    @Select("<script>"+
            "SELECT  station, health_level as healthlevel,( CASE HEALTH_LEVEL WHEN '危险' THEN 4 WHEN '警告' THEN 3 WHEN '注意' THEN 2 ELSE 1 END ) AS sort, count( 1 ) AS `value` FROM analysis_data.pv_health_index_day WHERE analysis_obj_type = #{analysisObjType} AND ts >= TODAY()-8h" +
            "<if test='area!= null'> AND area = #{area} </if> " +
            "<if test='station!= null'>AND station = #{station} </if>" +
            "<if test='gatewayIds != null and gatewayIds.size() > 0'>AND GATEWAY_ID IN <foreach collection='gatewayIds' item='gatewayId' open='(' separator=',' close=')'>#{gatewayId}</foreach></if>" +
            " GROUP BY station,health_level  order by sort"+
            "</script>")
    List<Map<String,Object>> selectEquipStatusByStationPv(@Param("area")String area, @Param("analysisObjType")String analysisObjType, @Param("station")String station, @Param("gatewayIds") List<String> gatewayIds);


    @Select("<script>"+
            "SELECT  station, health_level as healthlevel,( CASE health_level WHEN '危险' THEN 4 WHEN '警告' THEN 3 WHEN '注意' THEN 2 ELSE 1 END ) AS sort, count( 1 ) AS `value` FROM analysis_data.pv_health_index_day WHERE analysis_obj_type = #{analysisObjType} AND ts >= TODAY()-8h" +
            "<if test='station!= null'>AND station = #{station} </if>" +
            "<if test='equipmentName!= null'>AND equipment_name = #{equipmentName} </if>" +
            "<if test='subarray!= null'>AND subarray = #{subarray} </if>" +
            "<if test='gatewayIds != null and gatewayIds.size() > 0'>AND GATEWAY_ID IN <foreach collection='gatewayIds' item='gatewayId' open='(' separator=',' close=')'>#{gatewayId}</foreach></if>" +
            " GROUP BY station,health_level,equipment_name  order by sort"+
            "</script>")
    List<Map<String,Object>> selectEquipStatusByEquipment(@Param("analysisObjType")String analysisObjType,@Param("station")String station,@Param("equipmentName")String equipmentName, @Param("subarray") String subarray, @Param("gatewayIds") List<String> gatewayIds);

}
