package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 检查项
 *
 * @author duanwei
 * @date 2020-08-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_input_item")
@ApiModel(value = "InputItem对象", description = "检查项")
public class InputItem extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "作业类型")
    private String itemType;

    @ApiModelProperty(value = "检查项名称")
    private String name;

    @ApiModelProperty(value = "是否必填")
    private String isMust;

    @ApiModelProperty(value = "是否有分数")
    private String isScore;

    @ApiModelProperty(value = "是否允许多行")
    private String isMultiline;

    @ApiModelProperty(value = "默认值")
    private String defaultValue;

    @ApiModelProperty(value = "选项数据")
    private String inputJson;

    @ApiModelProperty(value = "图片数据")
    private String pictureJson;


    @ApiModelProperty(value = "描述")
    private String remark;


}
