package com.yeejoin.precontrol.common.enums;

public enum TaskRiskTrajectoryStatusEnum {
    passed("passed", "已完成认定，可以入场", "green"),
    knowledgeNotRead("knowledgeNotRead", "未学习安全考核知识", "red"),
    examNotPassed("examNotPassed", "安全考核未通过", "red"),
    knowledgeNotReadTech("knowledgeNotReadTech", "未学习技术考核知识", "red"),
    examNotPassedTech("examNotPassedTech", "技术考核未通过", "red"),
    unknownSec("unknownSec", "安全考核未识别的人员", "red"),
	unknownTech("unknownTech", "技术考核未识别的人员", "red"),
    unknown("unknown", "未识别的人员", "red");

    private String code;
    private String description;
    private String color;

    TaskRiskTrajectoryStatusEnum(String code, String description, String color) {
        this.code = code;
        this.description = description;
        this.color = color;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public static String getDescriptionByCode(String code) {
        String name = null;
        for (TaskRiskTrajectoryStatusEnum enumOne : TaskRiskTrajectoryStatusEnum.values()) {
            if (enumOne.getCode().equals(code)) {
                name = enumOne.getDescription();
                break;
            }
        }
        return name;
    }

    public static TaskRiskTrajectoryStatusEnum getEnumByCode(String code) {
        for (TaskRiskTrajectoryStatusEnum enumOne : TaskRiskTrajectoryStatusEnum.values()) {
            if (enumOne.getCode().equals(code)) {
                return enumOne;
            }
        }
        return null;
    }
}
