package com.yeejoin.amos.boot.module.ugp.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 项目安装告知短信记录表
 *
 * @author system_generator
 * @date 2022-10-7
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="InstallNoticeMsgPageDto", description="项目安装告知短信通知记录表")
public class InstallNoticeMsgPageDto extends BaseDto {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "项目名称")
    private String name;

    @ApiModelProperty(value = "项目安装区域")
    private String installRegion;

    @ApiModelProperty(value = "项目开工日期")
    private Date startDate;

    @ApiModelProperty(value = "建设单位")
    private String constructionUnit;

    @ApiModelProperty(value = "安装单位")
    private String installationUnit;

    @ApiModelProperty(value = "项目告知处理进度")
    private String progressStatus;

    @ApiModelProperty(value = "短信通知单位")
    private Long targetUnitId;
    private String targetUnitIdName;

    @ApiModelProperty(value = "短信接收人")
    private Long targetPersonId;
    private String targetPersonIdName;
    @ApiModelProperty(value = "短信通知内容")
    private String content;

    @ApiModelProperty(value = "短信发送日期")
    private Date sendTime;

}
