package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.ugp.api.entity.WorkHistory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import org.apache.commons.lang3.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.ugp.biz.service.impl.WorkHistoryServiceImpl;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.WorkHistoryDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 焊工工作履历表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "焊工工作履历表Api")
@RequestMapping(value = "/work-history")
public class WorkHistoryController extends BaseController {

    @Autowired
    WorkHistoryServiceImpl workHistoryServiceImpl;

    /**
     * 新增焊工工作履历表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增焊工工作履历表", notes = "新增焊工工作履历表")
	public ResponseModel<WorkHistoryDto> save(@RequestBody WorkHistoryDto model) {
	    model = workHistoryServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新焊工工作履历表", notes = "根据sequenceNbr更新焊工工作履历表")
	public ResponseModel<WorkHistoryDto> updateBySequenceNbrWorkHistory(@RequestBody WorkHistoryDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(workHistoryServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbrs 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbrs}")
	@Transactional
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除焊工工作履历表", notes = "根据sequenceNbr删除焊工工作履历表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbrs") List<Long> sequenceNbrs){
		boolean result = true;
		if(!ValidationUtil.isEmpty(sequenceNbrs)){
			for (Long sequenceNbr: sequenceNbrs) {
				result = workHistoryServiceImpl.removeById(sequenceNbr);
				if(!result){
					break;
				}
			}
		}
        return ResponseHelper.buildResponse(result);
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个焊工工作履历表",  notes = "根据sequenceNbr查询单个焊工工作履历表")
	public ResponseModel<WorkHistoryDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(workHistoryServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
	 * 列表分页查询
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/page", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public ResponseModel<IPage<WorkHistory>> listPage(String pageNum, String pageSize,
									   WorkHistory tzUgpWorkHistory){

		Page<WorkHistory> pageBean;
		QueryWrapper<WorkHistory> tzUgpWorkHistoryQueryWrapper = new QueryWrapper<>();
		Class<? extends WorkHistory> aClass = tzUgpWorkHistory.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(tzUgpWorkHistory);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(tzUgpWorkHistory);
						tzUgpWorkHistoryQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(tzUgpWorkHistory);
						tzUgpWorkHistoryQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(tzUgpWorkHistory);
						tzUgpWorkHistoryQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(tzUgpWorkHistory);
						tzUgpWorkHistoryQueryWrapper.eq(name, fileValue);
					}
				}
			}catch (Exception e) {
			}
		});
		IPage<WorkHistory> page;
		if (StringUtils.isBlank(pageNum)  ||StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		}else{
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = workHistoryServiceImpl.page(pageBean, tzUgpWorkHistoryQueryWrapper);
		return ResponseHelper.buildResponse(page);
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "焊工工作履历表列表全部数据查询",   notes = "焊工工作履历表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<WorkHistoryDto>> selectForList() {
	    return ResponseHelper.buildResponse(workHistoryServiceImpl.queryForWorkHistoryList());
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST",value = "分页查询",   notes = "分页查询")
	@PostMapping(value = "/pageList")
	public ResponseModel<IPage<WorkHistoryDto>> pageList(String pageNum, String pageSize,String sequenceNbr,@RequestBody(required = false) WorkHistoryDto tzUgpWorkHistory){
		if(ValidationUtil.isEmpty(pageNum)){
			pageNum = "1";
		}
		if(ValidationUtil.isEmpty(pageSize)){
			pageNum = "15";
		}
		Page<WorkHistoryDto> page = new Page(Integer.parseInt(pageNum),Integer.parseInt(pageSize));
		return ResponseHelper.buildResponse(workHistoryServiceImpl.pageList(page, tzUgpWorkHistory,sequenceNbr));
	}
}
