package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.sun.org.apache.xpath.internal.operations.Bool;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.ugp.api.Enum.RectifyMsgEnum;
import com.yeejoin.amos.boot.module.ugp.api.dto.*;
import com.yeejoin.amos.boot.module.ugp.api.entity.InstallNotice;
import com.yeejoin.amos.boot.module.ugp.api.entity.InstallNoticeMsg;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.entity.RectifyMsg;
import com.yeejoin.amos.boot.module.ugp.api.mapper.InstallNoticeMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.RectifyMsgMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IInstallNoticeMsgService;
import com.yeejoin.amos.boot.module.ugp.api.service.IRectifyMsgService;
import com.yeejoin.amos.boot.module.ugp.biz.framework.BusinessIdentify;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 整改短信通知表服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public class RectifyMsgServiceImpl extends BaseService<RectifyMsgDto,RectifyMsg,RectifyMsgMapper> implements IRectifyMsgService{

    @Autowired
    IRectifyMsgService iRectifyMsgService;

    @Autowired
    RectifyMsgMapper rectifyMsgMapper;

    @Autowired
    OrgServiceImpl orgService;


    @Autowired
    ProjectResourceServiceImpl projectResourceService;
    @Autowired
    InstallNoticeMapper installNoticeMapper;

    @Autowired
    InstallNoticeServiceImpl installNoticeService;


    /**
     * 质量问题整改短信列表查询
     */
    @Override
    public IPage<RectifyMsgDto> queryForRectifyMsgPage(IPage<RectifyMsgDto> page, String name, Boolean isProblem, String installationUnit) {
        LambdaQueryWrapper<RectifyMsg> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RectifyMsg::getIsProblem,isProblem);
        Set<Long> projectIds = new HashSet<>();
        List<Project> projectList = projectResourceService.getProjectList();
        for (Project project : projectList) {
            projectIds.add(project.getSequenceNbr());
        }
        page = rectifyMsgMapper.queryForRectifyMsgPage(page,name,isProblem,installationUnit,projectIds);
       return page;
    }

    @Override
    public Page<RectifyMsgDto> installNoticeMsgList(Page<RectifyMsgDto> page, String name, String installationUnit) {
        List<Project> projectList = projectResourceService.getProjectList();
        List<InstallNotice> installNoticeList = new ArrayList<>();
        List<RectifyMsgDto> pageDtoList = new ArrayList<>();
        for (Project project : projectList) {
            LambdaQueryWrapper<InstallNotice> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(InstallNotice::getProjectId, project.getSequenceNbr());
            List<InstallNotice> installNotice = installNoticeService.list(wrapper);
            installNoticeList.addAll(installNotice);
        }
        Set<String> seqs = new HashSet<>();
        for (InstallNotice installNotice : installNoticeList) {
            String seq = String.valueOf(installNotice.getSequenceNbr());
            seqs.add(seq);
        }
        Page<RectifyMsgDto> rectifyMsgDtoPageDtoPage = rectifyMsgMapper.InstallNoticeMsgPage(page, name, installationUnit, seqs);

        for (RectifyMsgDto i : rectifyMsgDtoPageDtoPage.getRecords()) {
            OrgUsr orgUsrById = orgService.getOrgId(String.valueOf(i.getNoticeUnitId()));
            //回显
            i.setNoticeUnitName(String.valueOf(orgUsrById.getBizOrgName()));
            //接收人
            OrgUsr orgUsrById1 = orgService.getOrgUsrById(String.valueOf(i.getMsgReceiver()));
            i.setMsgReceiverName(String.valueOf(orgUsrById1.getBizOrgName()));

            pageDtoList.add(i);

        }
        rectifyMsgDtoPageDtoPage.setRecords(pageDtoList);
        return rectifyMsgDtoPageDtoPage;
    }

    @Override
    public Page<RectifyMsgDto> selectByName(Page<RectifyMsgDto> page, String name, String unit) {
        return this.getBaseMapper().selectByName(page,name,unit);
    }

    @Override
    public RectifyMsgDto customSelectById(Long sequenceNbr) {
        return this.getBaseMapper().customSelectById(sequenceNbr);
    }

    /**
     * 列表查询 示例
     */
    public List<RectifyMsgDto> queryForRectifyMsgList()   {
        return this.queryForList("" , false);
    }

    /**
     * 消息提醒
     */
    @BusinessIdentify
    public List<MsgNoticeDto> msgNotice(Boolean isRead){
        LambdaQueryWrapper<RectifyMsg> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RectifyMsg::getMsgReceiver,orgService.getReginParams().getBusinessInfo().getUserSequenceNbr())
                .orderByDesc(RectifyMsg::getSendTime);
        if(!ValidationUtil.isEmpty(isRead)){
            wrapper.eq(RectifyMsg::getIsRead,isRead);
        }
        List<RectifyMsg> rectifyMsgList = rectifyMsgMapper.selectList(wrapper);
        List<MsgNoticeDto> msgNoticeDtoList = new ArrayList<>();
            if (!ValidationUtil.isEmpty(rectifyMsgList)) {
                for (RectifyMsg rectifyMsg : rectifyMsgList) {
                    MsgNoticeDto msgNoticeDto = new MsgNoticeDto();
                    String contents = rectifyMsg.getContent();
                    if (!ValidationUtil.isEmpty(contents)) {
                        msgNoticeDto.setType(contents.substring(contents.indexOf('【') + 1, contents.indexOf("】")));
                        msgNoticeDto.setContent(contents.substring(contents.indexOf("】") + 1));
                    }
                    if (!ValidationUtil.isEmpty(rectifyMsg.getIsRead())) {
                        if (rectifyMsg.getIsRead()) {
                            msgNoticeDto.setStatus("已读");
                        } else {
                            msgNoticeDto.setStatus("未读");
                        }
                    }
                    msgNoticeDto.setCreateDate(rectifyMsg.getSendTime());
                    msgNoticeDto.setSequenceNbr(rectifyMsg.getSequenceNbr());
                    msgNoticeDtoList.add(msgNoticeDto);
                }

        }

        return msgNoticeDtoList;
    }


    @BusinessIdentify
    public List<MsgNoticeDto> allRead(){
        LambdaQueryWrapper<RectifyMsg> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RectifyMsg::getMsgReceiver,orgService.getReginParams().getBusinessInfo().getUserSequenceNbr())
                .orderByDesc(RectifyMsg::getSendTime);
        List<RectifyMsg> rectifyMsgList = rectifyMsgMapper.selectList(wrapper);
        List<MsgNoticeDto> msgNoticeDtoList = new ArrayList<>();
            if(!ValidationUtil.isEmpty(rectifyMsgList)) {
                for (RectifyMsg rectifyMsg : rectifyMsgList) {
                    MsgNoticeDto msgNoticeDto = new MsgNoticeDto();
                    String contents = rectifyMsg.getContent();
                    msgNoticeDto.setCreateDate(rectifyMsg.getSendTime());
                    msgNoticeDto.setSequenceNbr(rectifyMsg.getSequenceNbr());
                    if (!ValidationUtil.isEmpty(contents)) {
                        msgNoticeDto.setType(contents.substring(contents.indexOf('【') + 1, contents.indexOf("】")));
                        msgNoticeDto.setContent(contents.substring(contents.indexOf("】") + 1));
                    }
                    if (!ValidationUtil.isEmpty(rectifyMsg.getIsRead())) {
                        msgNoticeDto.setStatus("已读");
                        rectifyMsg.setIsRead(true);
                        rectifyMsgMapper.updateById(rectifyMsg);
                    }
                    msgNoticeDtoList.add(msgNoticeDto);
                }
            }

    return msgNoticeDtoList;
        }



}