package com.yeejoin.amos.api.openapi.face.orm.entity;

import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import lombok.Data;
import lombok.EqualsAndHashCode;
/**
  * 企业数据对接票据管理
 * @author kinky
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("iot_openapi_biz_token")
public class OpenapiBizToken  extends BaseEntity{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * 应用用户票据，唯一标识
	 */
	@TableField("APP_ID")
	private String appId;
	/**
	 * 默认登录用户
	 */
	@TableField("USER_NAME")
	private String userName;
	/**
	 * 默认登录密码
	 */
	@TableField("PASS_WORD")
	private String passWord;
	/**
	 * 应用编号
	 */
	@TableField("APP_KEY")
	private String appKey;
	/**
	 * 客户端标识
	 */
	@TableField("PRODUCT")
	private String product;
	/**
	 * 所属机构
	 */
	@TableField("AGENCY_CODE")
	private String agencyCode;
	/**
	 * 对接公司名称
	 */
	@TableField("API_COMPANY_NAME")
	private String apiCompanyName;
	/**
	 * 对接公司编码
	 */
	@TableField("API_COMPANY_CODE")
	private String apiCompanyCode;
	/**
	 * 服务机构-开发机构
	 */
	@TableField("DEVELOPER_AGENCY")
	private String developerAgency;
	/**
	 * 对接数据分类
	 */
	@TableField("DATA_TYPE")
	private String dataType;
}
