package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 设备信息
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("tm_special_equ")
public class SpecialEqu extends AbstractBaseEntity {

	private static final long serialVersionUID = 1L;
	/**
	 * 必填，监察为准，原码保持
	 */
	@TableField("sequence_code")
	private String sequenceCode;
	/**
	 * 系统设备ID
	 */
	@TableField("equi_id")
	private String equiId;
	/**
	 * 注册状态
	 */
	@TableField("register_state")
	private String registerState;
	/**
	 * 使用状态
	 */
	@TableField("use_state")
	private String useState;
	/**
	 * 注册登记机构
	 */
	@TableField("register_org")
	private String registerOrg;
	/**
	 * 注册登记日期
	 */
	@TableField("register_date")
	private String registerDate;
	/**
	 * 设备注册代码
	 */
	@TableField("equ_register_code")
	private String equRegisterCode;
	/**
	 * 注册登记人员
	 */
	@TableField("register_user")
	private String registerUser;
	/**
	 * 使用登记证编号
	 */
	@TableField("use_code")
	private String useCode;
	/**
	 * 发证类型
	 */
	@TableField("certificates_type")
	private String certificatesType;
	/**
	 * 发证机构
	 */
	@TableField("certificates_org")
	private String certificatesOrg;
	/**
	 * 发证日期
	 */
	@TableField("certificates_date")
	private String certificatesDate;
	/**
	 * 首次发证日期
	 */
	@TableField("first_certificates_date")
	private String firstCertificatesDate;
	/**
	 * 有效期至
	 */
	@TableField("valid_until_date")
	private String validUntilDate;
	/**
	 * 设备类别
	 */
	@TableField("equ_category")
	private String equCategory;
	/**
	 * 设备类别代码
	 */
	@TableField("equ_category_code")
	private String equCategoryCode;
	/**
	 * 设备品种
	 */
	@TableField("equ_define")
	private String equDefine;
	/**
	 * 产品名称
	 */
	@TableField("product_name")
	private String productName;
	/**
	 * 产品编号
	 */
	@TableField("product_code")
	private String productCode;
	/**
	 * 设备代码
	 */
	@TableField("equ_code")
	private String equCode;
	/**
	 * 型号（规格）
	 */
	@TableField("equ_type")
	private String equType;
	/**
	 * 设计使用年限
	 */
	@TableField("design_use_years")
	private String designUseYears;
	/**
	 * 设计单位名称
	 */
	@TableField("design_unit_name")
	private String designUnitName;
	/**
	 * 设计单位统一信用代码
	 */
	@TableField("design_unit_credit_code")
	private String designUnitCreditCode;
	/**
	 * 制造单位名称
	 */
	@TableField("manufacture_unit_name")
	private String manufactureUnitName;
	/**
	 * 制造单位统一信用代码
	 */
	@TableField("manufacture_unit_credit_code")
	private String manufactureUnitCreditCode;
	/**
	 * 施工单位名称
	 */
	@TableField("construction_unit_name")
	private String constructionUnitName;
	/**
	 * 施工单位统一信用代码
	 */
	@TableField("construction_unit_credit_code")
	private String constructionUnitCreditCode;
	/**
	 * 制造日期
	 */
	@TableField("manufacture_date")
	private String manufactureDate;
	/**
	 * 监督检验机构名称
	 */
	@TableField("supervision_inspection_org_name")
	private String supervisionInspectionOrgName;
	/**
	 * 型式试验机构名称
	 */
	@TableField("type_test_org_name")
	private String typeTestOrgName;
	/**
	 * 固定检验地址
	 */
	@TableField("fixed_inspection_address")
	private String fixedInspectionAddress;
	/**
	 * 维保单位
	 */
	@TableField("maintenance_unit")
	private String maintenanceUnit;
	/**
	 * 维保单位统一信用代码
	 */
	@TableField("maintenance_unit_credit_code")
	private String maintenanceUnitCreditCode;
	/**
	 * 应急救援电话
	 */
	@TableField("emergency_rescue_phone")
	private String emergencyRescuePhone;
	/**
	 * 使用单位名称
	 */
	@TableField("use_unit_name")
	private String useUnitName;
	/**
	 * 所在地区代码
	 */
	@TableField("region_code")
	private String regionCode;
	/**
	 * 使用单位地址
	 */
	@TableField("use_unit_address")
	private String useUnitAddress;
	/**
	 * 使用单位统一社会信用代码
	 */
	@TableField("use_unit_credit_code")
	private String useUnitCreditCode;
	/**
	 * 邮政编码
	 */
	@TableField("postal_code")
	private String postalCode;
	/**
	 * 单位内编号
	 */
	@TableField("unit_inner_code")
	private String unitInnerCode;
	/**
	 * 设备使用地点
	 */
	@TableField("equ_use_address")
	private String equUseAddress;
	/**
	 * 投入使用日期
	 */
	@TableField("invest_use_date")
	private String investUseDate;
	/**
	 * 单位固定电话
	 */
	@TableField("unit_fixed_phone")
	private String unitFixedPhone;
	/**
	 * 安全管理员
	 */
	@TableField("safe_officer")
	private String safeOfficer;
	/**
	 * 安全管理联系电话
	 */
	@TableField("safe_officer_phone")
	private String safeOfficerPhone;
	/**
	 * 产权单位
	 */
	@TableField("owner_unit")
	private String ownerUnit;
	/**
	 * 产权单位统一社会信用代码
	 */
	@TableField("owner_unit_credit_code")
	private String ownerUnitCreditCode;
	/**
	 * 联系电话
	 */
	@TableField("phone")
	private String phone;
	/**
	 * 经度
	 */
	@TableField("longitude")
	private String longitude;
	/**
	 * 纬度
	 */
	@TableField("latitude")
	private String latitude;

}
