package com.yeejoin.amos.boot.module.ccs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 消防建筑表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("ast_fire_building")
public class FireBuilding extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 站点编码
     */
    @TableField("station_code")
    private String stationCode;

    /**
     * 站点名称
     */
    @TableField("station_name")
    private String stationName;

    /**
     * 消防建筑唯一标识
     */
    @TableField("mrid")
    private String mrid;

    /**
     * 名称
     */
    @TableField("name")
    private String name;

    /**
     * 建筑类别
     */
    @TableField("classify")
    private String classify;

    /**
     * 楼层数量
     */
    @TableField("floor_number")
    private String floorNumber;

    /**
     * 包含装备数量
     */
    private String equipmentNumber;

    /**
     * 父级mrid
     */
    @TableField("parent_mrid")
    private String parentMrid;


    /**
     * 树形mrids，包括自己，冗余用于树形查询
     */
    private String treeMrids;

    /**
     * 类型（建筑、楼层、房间）
     */
    @TableField("type")
    private String type;

    /**
     * 建筑图片
     */
    @TableField("photo_url")
    private String photoUrl;

    /**
     * 经度
     */
    @TableField("lng")
    private String lng;

    /**
     * 纬度
     */
    @TableField("lat")
    private String lat;

    /**
     * 详情位置
     */
    private String position;
    
    /**
     * 属性信息
     */
    private String attribute;

}
