package com.yeejoin.amos.boot.module.ccs.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireEquipmentSignalLogDto;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireEquipmentDto;
import com.yeejoin.amos.boot.module.ccs.api.entity.FireEquipmentSignalLog;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 设备报警信息日志表 Mapper 接口
 *
 * @author system_generator
 * @date 2021-11-09
 */
public interface FireEquipmentSignalLogMapper extends BaseMapper<FireEquipmentSignalLog> {

    /**
     * 告警日志
     *
     * @param params 查询参数
     * @return List<FireEquipmentAlarmLogDto>
     */
    List<FireEquipmentSignalLogDto> queryAlarmLogList(Map<String, Object> params);

    /**
     * 查询指定日期的告警设备（去重）
     * @param stationCode 换流站编号
     * @param alarmDate 告警日期
     * @return List<FireEquipmentDto>
     */
    List<FireEquipmentDto> distinctByEquipmentId(@Param("stationCode") String stationCode, @Param("alarmDate") String alarmDate);
}
