package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;

import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 救援装备
 *
 * @author system_generator
 * @date 2021-07-23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "RescueEquipmentDto", description = "救援装备")
public class RescueEquipmentDto extends BaseDto {

    @ExcelIgnore
    private static final long serialVersionUID = 1L;


    @ExcelProperty(value = "车辆类型", index = 0)
    @ExplicitConstraint(type = "JYZBLX", indexNum = 0, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ApiModelProperty(value = "车辆类型")
    private String vehicleType;

    @ExcelIgnore
    @ApiModelProperty(value = "车辆类型code")
    private String vehicleTypeCode;

    @ExcelProperty(value = "车辆数量", index = 1)
    @ApiModelProperty(value = "车辆数量")
    private Long vehicleNumber;

    @ExcelProperty(value = "费用", index = 2)
    @ApiModelProperty(value = "费用")
    private Double fee;

    @ExcelProperty(value = "单位名称", index =3)
    @ExplicitConstraint(indexNum = 3, sourceClass = CommonExplicitConstraint.class,method="getUnitTeam") //动态下拉内容
    @ApiModelProperty(value = "单位名称")
    private String company;

    @ExcelIgnore
    @ApiModelProperty(value = "单位id")
    private Long companyId;

    @ExcelIgnore
    @ApiModelProperty(value = "更新人名称")
    private String recUserName;

}
