package com.yeejoin.equipmanage.common.enums;


/**
 * 系统类型枚举
 */
public enum SystemTypeEnum {
	 /**
     * message={
     * "systemCode":""
     * //fireResources(资源概率);fireCAFSSys（CAFS系统）；fireAlarmSys（火灾报警系统）；fireONLSys（排油系统）；fireFoamSys（泡沫灭火系统）；fireWaterSys（消防给水系统）；fireFoamMistSys（细水雾涡扇炮系统）
     */
	fireCAFSSys("fireCAFSSys", "CAFS系统" ),
	fireAlarmSys("fireAlarmSys", "火灾报警系统"),
	fireONLSys("fireONLSys", "排油系统"),
	fireFoamSys("fireFoamSys", "预混泡沫灭火系统"),
	fireFoamMistSys("fireFoamMistSys", "细水雾涡扇炮系统"),
	fireWaterSys("fireWaterSys", "消防给水系统"),
	otherSys("otherSys", "其他系统"),
	envMonitoringSys("envMonitoringSys", "环境监测系统");


    private String code;

    public String getCode() {
		return code;
	}


	public void setCode(String code) {
		this.code = code;
	}


	public String getDesc() {
		return desc;
	}


	public void setDesc(String desc) {
		this.desc = desc;
	}


	private String desc;


    SystemTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

   
    public static SystemTypeEnum getEnum(String code)
    {
        for (SystemTypeEnum systemTypeEnum : SystemTypeEnum.values())
        {
            if (systemTypeEnum.getCode().equals(code))
            {
                return systemTypeEnum;

            }
        }
        return null;
    }
}
