package com.yeejoin.amos.fas.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * The persistent class for the evaluation_model database table.
 * 
 */
@Entity
@Table(name="f_evaluation_model")
@NamedQuery(name="EvaluationModel.findAll", query="SELECT e FROM EvaluationModel e")
public class EvaluationModel extends BasicEntity  {
	private static final long serialVersionUID = 1L;

	@Column(name="create_by")
	private String createBy;

	private String name;
	
	/**
	 * 系数
	 */
	private String coefficient;

	/**
	 * 影响
	 */
	private String influence;
	
	/**
	 * 描述
	 */
	private String describe;
	
	/**
	 * S,D,O
	 */
	private String type;
	
	@Column(name="org_code")
	private String orgCode;

	
	private String remark;

	@Lob
	private String standard;

	public EvaluationModel() {
	}

	public String getCreateBy() {
		return this.createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getStandard() {
		return this.standard;
	}

	public void setStandard(String standard) {
		this.standard = standard;
	}

	public String getCoefficient() {
		return coefficient;
	}

	public void setCoefficient(String coefficient) {
		this.coefficient = coefficient;
	}

	public String getInfluence() {
		return influence;
	}

	public void setInfluence(String influence) {
		this.influence = influence;
	}

	public String getDescribe() {
		return describe;
	}

	public void setDescribe(String describe) {
		this.describe = describe;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

}