package com.yeejoin.amos.maintenance.dao.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * The persistent class for the p_catalog_tree database table.
 * 
 */
@Entity
@Table(name="p_catalog_tree")
@NamedQuery(name="CatalogTree.findAll", query="SELECT c FROM CatalogTree c")
public class CatalogTree extends BasicEntity {

	private static final long serialVersionUID = 1L;
	
	/**
     * 创建者
     */
	@Column(name="create_by")
	private int createBy;


	/**
	 * 分类名称
	 */
	private String name;

	/**
	 * 排序号
	 */
	@Column(name="order_no")
	private int orderNo;

	/**
	 * 权限系统org code
	 */
	@Column(name="org_code")
	private String orgCode;

	/**
	 * 上级分类id
	 */
	@Column(name="parent_id")
	private int parentId;

	public CatalogTree() {
	}


	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getOrderNo() {
		return this.orderNo;
	}

	public void setOrderNo(int orderNo) {
		this.orderNo = orderNo;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public int getParentId() {
		return this.parentId;
	}

	public void setParentId(int parentId) {
		this.parentId = parentId;
	}

	public int getCreateBy() {
		return createBy;
	}

	public void setCreateBy(int createBy) {
		this.createBy = createBy;
	}

}