package com.yeejoin.amos.supervision.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PlanStatusEnum {

    DRAFT("草稿",0, 1),
    EXAMINE_ONE("一级待审核",1, 2),
    EXAMINE_TWO("二级待审核",2, 3),
    EXAMINE_THREE("三级待审核",3, 4),
    EXAMINE_FORMULATE("已审核/检查内容未制定",4, 5),
    EXAMINE_DEVELOPED("检查内容已制定/未执行",5, 6),
    IN_EXECUTION("执行中",6, 7),
    COMPLETED("已完成",7, 7),
    OUT_TIME("已超时",8, 8);


    /**
     * 名称
     */
    private String name;

    /**
     * 值
     */
    private int value;

    private int nextStatus;

    private PlanStatusEnum(String name, int value, int nextStatus) {
        this.name = name;
        this.value = value;
        this.nextStatus = nextStatus;
    }


    public static String getName(int value) {
        for (PlanStatusEnum c : PlanStatusEnum.values()) {
            if (c.getValue() == value) {
                return c.name;
            }
        }
        return null;
    }

    public static int getValue(String name) {
        for (PlanStatusEnum c : PlanStatusEnum.values()) {
            if (c.getName().equals(name)) {
                return c.value;
            }
        }
        return -1;
    }


    public static PlanStatusEnum getEnum(int value) {
        for (PlanStatusEnum c : PlanStatusEnum.values()) {
            if (c.getValue() == value) {
                return c;
            }
        }
        return null;
    }


    public static PlanStatusEnum getEnum(String name) {
        for (PlanStatusEnum c : PlanStatusEnum.values()) {
            if (c.getName().equals(name)) {
                return c;
            }
        }
        return null;
    }

    public static List<Map<String,String>> getEnumList() {
        List<Map<String,String>> nameList = new ArrayList<>();
        for (PlanStatusEnum c: PlanStatusEnum.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("name", c.getName());
            map.put("value", c.getValue() +"");
            nameList.add(map);
        }
        return nameList;
    }

    public static List<String> getEnumNameList() {
        List<String> nameList = new ArrayList<String>();
        for (PlanStatusEnum c: PlanStatusEnum.values()) {
            nameList.add(c.getName());
        }
        return nameList;
    }

    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }


    public int getValue() {
        return value;
    }


    public void setValue(int value) {
        this.value = value;
    }

    public int getNextStatus() {
        return nextStatus;
    }

    public void setNextStatus(int nextStatus) {
        this.nextStatus = nextStatus;
    }
}
