package com.yeejoin.amos.supervision.dao.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@TableName("p_check_report")
public class CheckReport extends BasicEntity {

    @ApiModelProperty(value = "报告名称")
    String name;

    @ApiModelProperty(value = "计划类型（0单位级，1公司级）")
    int planType;

    @ApiModelProperty(value = "计划任务id")
    Long planTaskId;

    @ApiModelProperty(value = "任务执行人")
    String checkUser;

    @ApiModelProperty(value = "实际开始时间")
    Date startCheckDate;

    @ApiModelProperty(value = "实际结束时间")
    Date endCheckDate;

    @ApiModelProperty(value = "检查单位数量")
    Integer companyCount;

    @ApiModelProperty(value = "存在问题单位数量")
    Integer problemCompanyCount;

    @ApiModelProperty(value = "是否有重大隐患（1有，0无）")
    Boolean hasMajorDanger;

    @ApiModelProperty(value = "存在安全隐患id(逗号分割)")
    String dangerIds;

    @ApiModelProperty(value = "存在安全隐患数量")
    Integer dangerCount;

    @ApiModelProperty(value = "复查隐患id(逗号分割)")
    String reviewDangerIds;

    @ApiModelProperty(value = "现场已整改隐患数量")
    Integer onsiteReformCount;

    @ApiModelProperty(value = "复查隐患数量")
    Integer reviewDangerCount;

    @ApiModelProperty(value = "复查已整改隐患数量")
    Integer reviewReformedCount;

    @ApiModelProperty(value = "复查整改中隐患数量")
    Integer reviewReformingCount;

    @ApiModelProperty(value = "剩余隐患数量")
    Integer remainingDangerCount;

    @ApiModelProperty(value = "机构代码")
    String orgCode;
}
