package com.yeejoin.equipmanage.controller;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.feign.morphic.model.ResourceDTO;
import com.yeejoin.equipmanage.common.entity.RiskSourceScene;
import com.yeejoin.equipmanage.common.entity.vo.PersonVo;
import com.yeejoin.equipmanage.common.entity.vo.PointTreeVo;
import com.yeejoin.equipmanage.common.entity.vo.RiskSourceTreeVO;
import com.yeejoin.equipmanage.common.response.RiskSourceTreeResponse;
import com.yeejoin.equipmanage.service.IRiskSourceSceneService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @author DELL
 */
@Api(tags = "风险场景关联")
@RestController
@RequestMapping("/scene")
public class RiskSourceSceneController extends AbstractBaseController {

    @Autowired
    private IRiskSourceSceneService iRiskSourceSceneService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询关系表详情")
    @GetMapping(value = "/{riskSourceId}")
    public RiskSourceScene selectOne(@PathVariable Long riskSourceId) {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = reginParams.getCompany().getOrgCode();
        return iRiskSourceSceneService.getOneByUniqueKey(riskSourceId, orgCode);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询风险区域树")
    @GetMapping(value = "/riskSource/tree", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public List<RiskSourceTreeResponse> getAreaTree() {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = reginParams.getCompany().getOrgCode();
        return iRiskSourceSceneService.getAreaTree(orgCode);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "创建画布")
    @PostMapping(value = "/add", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public RiskSourceScene createMorphic(@RequestBody RiskSourceScene model) {
        ReginParams reginParams = getSelectedOrgInfo();
        String orgCode = reginParams.getCompany().getOrgCode();
        model.setOrgCode(orgCode);
        return iRiskSourceSceneService.createModel(model);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "更新保存画布")
    @PutMapping(value = "/save", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResourceDTO updateMorphic(@RequestBody ResourceDTO resourceDTO) {
        return iRiskSourceSceneService.updateMorphic(resourceDTO);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询组态用到的接口", notes = "组态使用")
    @GetMapping(value = "/url/{dictCode}", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Object queryDictMap(@PathVariable String dictCode) {
        return iRiskSourceSceneService.queryDictMap(dictCode);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询部件类型列表", notes = "组态使用")
    @GetMapping(value = "/category/list", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public List getPartsList() {
        return iRiskSourceSceneService.queryPartType();
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询部件分页列表", notes = "组态使用")
    @GetMapping(value = "/{categoryId}/detail/list", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public IPage queryPartList(
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @PathVariable Long categoryId,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "code", required = false) String code
    ) {
        Page page = new Page(current, size);
        return iRiskSourceSceneService.queryPartListPage(page, categoryId, name, code);
    }

    /**
     * 获取风险点树型结构
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取风险点树型结构", notes = "获取风险点树型结构")
    @RequestMapping(value = "/riskSourceTress", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public List<RiskSourceTreeVO> getRiskSourceTress() {
        return iRiskSourceSceneService.findRiskSourceTrees(getOrgCode());
    }

    /**
     * 获取前四个视频
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取风险点树型结构", notes = "获取风险点树型结构")
    @RequestMapping(value = "/getFourVideo", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public List<RiskSourceTreeVO> getFourVideo() {
        return iRiskSourceSceneService.getFourVideo();
    }

    /**
     * 获取执勤力量列表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取执勤力量列表", notes = "获取执勤力量列表")
    @RequestMapping(value = "/getPersonInfo", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public List<PersonVo> getPersonInfo() {
        return iRiskSourceSceneService.getPersonInfo();
    }


    /**
     * 获取点位图，区域树数据
     *
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取点位图，区域树数据")
    @GetMapping(value = "/point/tree", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public List<PointTreeVo> getPointTree() {
        return iRiskSourceSceneService.getPointTree(getOrgCode());
    }


    /**
     * 获取区域名称
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "首页区域图id")
    @GetMapping(value = "/getSceneName", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public String  getSceneName(String id ) {
        return iRiskSourceSceneService.getSceneName(id);
    }


    /**
     * 首页区域图id
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "首页区域图id")
    @GetMapping(value = "/getFirstCanvas", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Map<String, Object>  getFirstCanvas( ) {
        return iRiskSourceSceneService.getFirstCanvas(getOrgCode());
    }

    /**
     * 获取点位图，区域树数据
     *
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取点位图，重点设备树数据")
    @GetMapping(value = "/importantEquip/tree", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public List<PointTreeVo> getImportantEquip() {
        return iRiskSourceSceneService.getImportantEquip(getSelectedOrgInfo().getCompany().getOrgCode());
    }



    /**
     * 获取系统菜单
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取系统菜单")
    @GetMapping(value = "/getSystemmenuLsit", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public List<PointTreeVo>  getSystemmeanLsit( ) {
        return iRiskSourceSceneService.getSystemmeanLsit();
    }

    /**
     * 获取点位图预览信息
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取点位图预览信息")
    @PostMapping(value = "/getSceneData", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public Map<String ,Object> getSceneData(@RequestBody PointTreeVo vo) {
        return iRiskSourceSceneService.getSceneData(vo,getOrgCode());
    }



//    /**
//     * 区域画布保存
//     */
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "区域画布保存")
//    @PostMapping(value = "/point/save", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
//    public String  saveMorphic(@RequestBody PointTreeVo PointTreeVo) {
//        PointTreeVo.setOrgCode(getOrgCode());
//        return iRiskSourceSceneService.saveMorphic(PointTreeVo);
//    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "今日安全指数查询",notes = "按照日期查询安全指数及分类数据")
	@GetMapping(value = "/statistics/safetyIndex")
	public Map<String,Object> getSafetyIndexInfoByDate(){
		return iRiskSourceSceneService.getSafetyIndexInfoByDate();
	}

    /**
     * 二级区域风险等级，风险值
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "二级区域风险等级，风险值", notes = "二级区域风险等级，风险值")
    @RequestMapping(value = "/secondLevelRiskSource", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public List<Map<String,Object>> queryRiskSourceSecondLevel() {
        return iRiskSourceSceneService.queryRiskSourceSecondLevel();
    }

    /**
     * 设备报警信息
     * @return
     */
    @GetMapping(value = "/getStatus")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public  List<Map> getstatus(@RequestParam(value = "sceneId", required = false) String sceneId){
        return iRiskSourceSceneService.getstatus(sceneId);
    }

     /**
     * 根据风险位置获取装备
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据风险位置获取装备", notes = "根据风险位置获取装备")
    @RequestMapping(value = "/getEquipBySourceId", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public IPage getEquipByRiskSource(
            @RequestParam(value = "pageNumber") int pageNumber,
            @RequestParam(value = "pageSize") int pageSize,
            @RequestParam(value = "sourceId") String sourceId,
            @RequestParam(value = "categoryId" ,required = false) String categoryId,
            @RequestParam(value = "equipCode",required = false) String equipCode,
            @RequestParam(value = "equipName",required = false) String equipName
    ) {
        Page page = new Page(pageNumber, pageSize);
        return iRiskSourceSceneService.getEquipBySourceId(page, sourceId,categoryId,equipCode,equipName);
    }

}
