package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.SignalClassify;
import com.yeejoin.equipmanage.mapper.SignalClassifyMapper;
import com.yeejoin.equipmanage.service.ISignalClassifyService;
import org.springframework.stereotype.Service;

/**
 * 信号分类量测枚举表服务实现类
 *
 * @author system_generator
 * @date 2022-02-18
 */
@Service
public class SignalClassifyServiceImpl extends ServiceImpl<SignalClassifyMapper, SignalClassify> implements ISignalClassifyService {

    @Override
    public SignalClassify getTypeNameByCode(String code) {
        return this.baseMapper.selectOne(new LambdaQueryWrapper<SignalClassify>().eq(SignalClassify::getTypeCode, code));
    }
}